/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.db.DBAppender;
import ch.qos.logback.classic.db.DBAppenderTestBase;
import ch.qos.logback.classic.db.DBHelper;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DriverManagerConnectionSource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class DBAppenderTest
extends DBAppenderTestBase {
    LoggerContext lc;
    Logger logger;
    DBAppender appender;
    DriverManagerConnectionSource connectionSource;

    public DBAppenderTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        super.setUp();
        this.lc = new LoggerContext();
        this.lc.setName("default");
        this.logger = this.lc.getLogger("root");
        this.appender = new DBAppender();
        this.appender.setName("DB");
        this.appender.setContext((Context)this.lc);
        this.connectionSource = new DriverManagerConnectionSource();
        this.connectionSource.setContext((Context)this.lc);
        this.connectionSource.setDriverClass("org.hsqldb.jdbcDriver");
        this.connectionSource.setUrl(this.url);
        this.connectionSource.setUser(this.user);
        this.connectionSource.setPassword(this.password);
        this.connectionSource.start();
        this.appender.setConnectionSource((ConnectionSource)this.connectionSource);
        this.appender.start();
    }

    public void tearDown() throws SQLException {
        super.tearDown();
        this.logger = null;
        this.lc = null;
        this.appender = null;
        this.connectionSource = null;
    }

    public void testAppendLoggingEvent() throws SQLException {
        LoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event");
        if (rs.next()) {
            DBAppenderTest.assertEquals((long)event.getTimeStamp(), (long)rs.getLong(1));
            DBAppenderTest.assertEquals((String)event.getFormattedMessage(), (String)rs.getString(2));
            DBAppenderTest.assertEquals((String)event.getLoggerRemoteView().getName(), (String)rs.getString(3));
            DBAppenderTest.assertEquals((String)event.getLevel().toString(), (String)rs.getString(4));
            DBAppenderTest.assertEquals((String)event.getThreadName(), (String)rs.getString(5));
            DBAppenderTest.assertEquals((short)DBHelper.computeReferenceMask((LoggingEvent)event), (short)rs.getShort(6));
            CallerData callerData = event.getCallerData()[0];
            DBAppenderTest.assertEquals((String)callerData.getFileName(), (String)rs.getString(7));
            DBAppenderTest.assertEquals((String)callerData.getClassName(), (String)rs.getString(8));
            DBAppenderTest.assertEquals((String)callerData.getMethodName(), (String)rs.getString(9));
        } else {
            DBAppenderTest.fail((String)"No row was inserted in the database");
        }
        rs.close();
        stmt.close();
    }

    public void testAppendThrowable() throws SQLException {
        LoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event_exception where event_id = 0");
        int i = 0;
        while (rs.next()) {
            DBAppenderTest.assertEquals((String)event.getThrowableInformation().getThrowableStrRep()[i], (String)rs.getString(3));
            ++i;
        }
        rs.close();
        stmt.close();
    }

    public void testContextInfo() throws SQLException {
        LoggingEvent event = this.createLoggingEvent();
        this.lc.setProperty("testKey1", "testValue1");
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event_property where event_id = 0");
        Map map = this.appender.mergePropertyMaps(event);
        while (rs.next()) {
            String key = rs.getString(2);
            DBAppenderTest.assertEquals((String)((String)map.get(key)), (String)rs.getString(3));
            System.out.println("value: " + (String)map.get(key));
        }
        rs.close();
        stmt.close();
    }

    public void testAppendMultipleEvents() throws SQLException {
        for (int i = 0; i < 10; ++i) {
            LoggingEvent event = this.createLoggingEvent();
            this.appender.append((Object)event);
        }
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event");
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        DBAppenderTest.assertEquals((int)10, (int)count);
        rs.close();
        stmt.close();
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(((Object)((Object)this)).getClass().getName(), this.logger, Level.DEBUG, "test message", (Throwable)new Exception("test Ex"), null);
        return le;
    }
}

