/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.control;

import ch.qos.logback.classic.Level;
import java.util.Random;

public class RandomUtil {
    private static final long SEED = 74130L;
    private static final Random random = new Random(74130L);
    private static final int AVERAGE_ID_LEN = 32;
    private static final int AVERAGE_ID_DEV = 16;
    private static final int AVERAGE_CHILDREN_COUNT = 30;
    private static final int CHILDREN_COUNT_VAR = 10;

    public static boolean oneInFreq(int freq) {
        return random.nextInt(freq) % freq == 0;
    }

    public static Level randomLevel() {
        int rl = random.nextInt(4);
        switch (rl) {
            case 0: {
                return Level.DEBUG;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARN;
            }
            case 3: {
                return Level.ERROR;
            }
        }
        throw new IllegalStateException("rl should have been a value between 0 to 3, but it is " + rl);
    }

    public static String randomLoggerName(int average, int stdDeviation) {
        int depth = RandomUtil.gaussianAsPositiveInt(average, stdDeviation);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append(RandomUtil.randomId());
        }
        return buf.toString();
    }

    public static String randomId() {
        int len = RandomUtil.gaussianAsPositiveInt(32, 16);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int offset = random.nextInt(26);
            char c = (char)(97 + offset);
            buf.append(c);
        }
        return buf.toString();
    }

    public static int gaussianAsPositiveInt(int average, int stdDeviation) {
        if (average < 1) {
            throw new IllegalArgumentException("The average must not be smaller than 1.");
        }
        if (stdDeviation < 1) {
            throw new IllegalArgumentException("The stdDeviation must not be smaller than 1.");
        }
        double d = random.nextGaussian() * (double)stdDeviation + (double)average;
        int result = 1;
        if (d > 1.0) {
            result = (int)Math.round(d);
        }
        return result;
    }

    public static int randomChildrenCount(String name) {
        if ("".equals(name)) {
            return 3;
        }
        int dots = RandomUtil.dotCount(name);
        if (dots == 1) {
            return 3;
        }
        if (dots == 2 || dots == 3) {
            return 9;
        }
        if (RandomUtil.hasChildren(0.5)) {
            return RandomUtil.gaussianAsPositiveInt(30, 10);
        }
        return 0;
    }

    static boolean hasChildren(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be a value between 0 and 1.0, it was " + p + " instead.");
        }
        double r = random.nextDouble();
        return r < p;
    }

    static int dotCount(String s) {
        int count = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c != '.') continue;
            ++count;
        }
        return count;
    }
}

