/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.lang.reflect.Method;
import org.slf4j.ILoggerFactory;
import org.slf4j.impl.Util;
import org.slf4j.spi.LoggerFactoryBinder;

public class SystemPropBinder
implements LoggerFactoryBinder {
    public static final String LOGGER_FACTORY_PROPERTY = "org.slf4j.factory";
    public static final String LOGGER_FACTORY_FACTORY_METHOD_NAME = "getInstance";
    String factoryFactoryClassName = null;

    public ILoggerFactory getLoggerFactory() {
        try {
            if (this.getLoggerFactoryClassStr() == null) {
                return null;
            }
            Class<?> factoryFactoryClass = Class.forName(this.getLoggerFactoryClassStr());
            Class[] EMPTY_CLASS_ARRAY = new Class[]{};
            Method factoryFactoryMethod = factoryFactoryClass.getDeclaredMethod(LOGGER_FACTORY_FACTORY_METHOD_NAME, EMPTY_CLASS_ARRAY);
            ILoggerFactory loggerFactory = (ILoggerFactory)factoryFactoryMethod.invoke(null, null);
            return loggerFactory;
        }
        catch (Exception e) {
            Util.reportFailure("Failed to fetch ILoggerFactory instnace using the " + this.factoryFactoryClassName + " class.", e);
            return null;
        }
    }

    public String getLoggerFactoryClassStr() {
        if (this.factoryFactoryClassName == null) {
            try {
                this.factoryFactoryClassName = System.getProperty(LOGGER_FACTORY_PROPERTY);
            }
            catch (Exception e) {
                Util.reportFailure("Failed to fetch org.slf4j.factory system property.", e);
            }
        }
        return this.factoryFactoryClassName;
    }
}

