/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyFixtureWithListAndConsoleAppenders;
import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.Util;
import ch.qos.logback.access.testUtil.NotifyingListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JettyBasicTest {
    static RequestLogImpl REQYEST_LOG_IMPL;
    static JettyFixtureWithListAndConsoleAppenders JETTY_FIXTURE;
    static int RANDOM_SERVER_PORT;

    @BeforeClass
    public static void startServer() throws Exception {
        REQYEST_LOG_IMPL = new RequestLogImpl();
        JETTY_FIXTURE = new JettyFixtureWithListAndConsoleAppenders(REQYEST_LOG_IMPL, RANDOM_SERVER_PORT);
        JETTY_FIXTURE.start();
    }

    @AfterClass
    public static void stopServer() throws Exception {
        if (JETTY_FIXTURE != null) {
            JETTY_FIXTURE.stop();
        }
    }

    @Test
    public void getRequest() throws Exception {
        URL url = new URL("http://localhost:" + RANDOM_SERVER_PORT + "/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        String result = Util.readToString((InputStream)connection.getInputStream());
        Assert.assertEquals((Object)"hello world", (Object)result);
        NotifyingListAppender listAppender = (NotifyingListAppender)REQYEST_LOG_IMPL.getAppender("list");
        listAppender.list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void eventGoesToAppenders() throws Exception {
        NotifyingListAppender listAppender;
        URL url = new URL(JETTY_FIXTURE.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        String result = Util.readToString((InputStream)connection.getInputStream());
        Assert.assertEquals((Object)"hello world", (Object)result);
        NotifyingListAppender notifyingListAppender = listAppender = (NotifyingListAppender)REQYEST_LOG_IMPL.getAppender("list");
        synchronized (notifyingListAppender) {
            ((Object)((Object)listAppender)).wait(100L);
        }
        Assert.assertTrue((listAppender.list.size() > 0 ? 1 : 0) != 0);
        IAccessEvent event = listAppender.list.get(0);
        Assert.assertEquals((Object)"127.0.0.1", (Object)event.getRemoteHost());
        Assert.assertEquals((Object)"localhost", (Object)event.getServerName());
        listAppender.list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postContentConverter() throws Exception {
        NotifyingListAppender listAppender;
        URL url = new URL(JETTY_FIXTURE.getUrl());
        String msg = "test message";
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setFixedLengthStreamingMode(msg.getBytes().length);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "text/plain");
        PrintWriter output = new PrintWriter(new OutputStreamWriter(connection.getOutputStream()));
        output.print(msg);
        output.flush();
        output.close();
        NotifyingListAppender notifyingListAppender = listAppender = (NotifyingListAppender)REQYEST_LOG_IMPL.getAppender("list");
        synchronized (notifyingListAppender) {
            ((Object)((Object)listAppender)).wait(100L);
        }
        IAccessEvent event = listAppender.list.get(0);
    }

    static {
        RANDOM_SERVER_PORT = RandomUtil.getRandomServerPort();
    }
}

