/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.db;

import ch.qos.logback.access.db.DBAppender;
import ch.qos.logback.access.db.DBAppenderTestBase;
import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DriverManagerConnectionSource;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DBAppenderTest
extends DBAppenderTestBase {
    AccessContext context;
    DBAppender appender;
    DriverManagerConnectionSource connectionSource;

    public DBAppenderTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        super.setUp();
        this.context = new AccessContext();
        this.context.setName("default");
        this.appender = new DBAppender();
        this.appender.setName("DB");
        this.appender.setContext((Context)this.context);
        this.connectionSource = new DriverManagerConnectionSource();
        this.connectionSource.setContext((Context)this.context);
        this.connectionSource.setDriverClass("org.hsqldb.jdbcDriver");
        this.connectionSource.setUrl(this.url);
        this.connectionSource.setUser(this.user);
        this.connectionSource.setPassword(this.password);
        this.connectionSource.start();
        this.appender.setConnectionSource((ConnectionSource)this.connectionSource);
    }

    private void setInsertHeadersAndStart(boolean insert) {
        this.appender.setInsertHeaders(insert);
        this.appender.start();
    }

    public void tearDown() throws SQLException {
        super.tearDown();
        this.context = null;
        this.appender = null;
        this.connectionSource = null;
    }

    public void testAppendAccessEvent() throws SQLException {
        this.setInsertHeadersAndStart(false);
        AccessEvent event = this.createAccessEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM access_event");
        if (rs.next()) {
            DBAppenderTest.assertEquals((long)event.getTimeStamp(), (long)rs.getLong(1));
            DBAppenderTest.assertEquals((String)event.getRequestURI(), (String)rs.getString(2));
            DBAppenderTest.assertEquals((String)event.getRequestURL(), (String)rs.getString(3));
            DBAppenderTest.assertEquals((String)event.getRemoteHost(), (String)rs.getString(4));
            DBAppenderTest.assertEquals((String)event.getRemoteUser(), (String)rs.getString(5));
            DBAppenderTest.assertEquals((String)event.getRemoteAddr(), (String)rs.getString(6));
            DBAppenderTest.assertEquals((String)event.getProtocol(), (String)rs.getString(7));
            DBAppenderTest.assertEquals((String)event.getMethod(), (String)rs.getString(8));
            DBAppenderTest.assertEquals((String)event.getServerName(), (String)rs.getString(9));
            DBAppenderTest.assertEquals((String)event.getRequestContent(), (String)rs.getString(10));
        } else {
            DBAppenderTest.fail((String)"No row was inserted in the database");
        }
        rs.close();
        stmt.close();
    }

    public void testCheckNoHeadersAreInserted() throws Exception {
        this.setInsertHeadersAndStart(false);
        AccessEvent event = this.createAccessEvent();
        this.appender.append((Object)event);
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM access_event_header");
        DBAppenderTest.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    public void testAppendHeaders() throws SQLException {
        this.setInsertHeadersAndStart(true);
        AccessEvent event = this.createAccessEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM access_event_header");
        if (!rs.next()) {
            DBAppenderTest.fail((String)"There should be results to this query");
        } else {
            String key = rs.getString(2);
            String value = rs.getString(3);
            DBAppenderTest.assertNotNull((Object)key);
            DBAppenderTest.assertNotNull((Object)value);
            DBAppenderTest.assertEquals((String)event.getRequestHeader(key), (String)value);
            rs.next();
            key = rs.getString(2);
            value = rs.getString(3);
            DBAppenderTest.assertNotNull((Object)key);
            DBAppenderTest.assertNotNull((Object)value);
            DBAppenderTest.assertEquals((String)event.getRequestHeader(key), (String)value);
        }
        if (rs.next()) {
            DBAppenderTest.fail((String)"There should be no more rows available");
        }
        rs.close();
        stmt.close();
    }

    public void testAppendMultipleEvents() throws SQLException {
        for (int i = 0; i < 10; ++i) {
            AccessEvent event = this.createAccessEvent();
            this.appender.append((Object)event);
        }
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM access_event");
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        DBAppenderTest.assertEquals((int)10, (int)count);
        rs.close();
        stmt.close();
    }

    private AccessEvent createAccessEvent() {
        DummyRequest request = new DummyRequest();
        DummyResponse response = new DummyResponse();
        DummyServerAdapter adapter = new DummyServerAdapter(request, response);
        AccessEvent ae = new AccessEvent((HttpServletRequest)request, (HttpServletResponse)response, (ServerAdapter)adapter);
        return ae;
    }
}

