/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.net.URLEvaluator;
import ch.qos.logback.access.pattern.helpers.DummyRequest;
import ch.qos.logback.access.pattern.helpers.DummyResponse;
import ch.qos.logback.access.pattern.helpers.DummyServerAdapter;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.boolex.EvaluationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;

public class URLEvaluatorTest
extends TestCase {
    final String expectedURL1 = "testUrl1";
    final String expectedURL2 = "testUrl2";
    Context context = new ContextBase();
    URLEvaluator evaluator;
    DummyRequest request;
    DummyResponse response;
    DummyServerAdapter serverAdapter;

    public void setUp() throws Exception {
        this.evaluator = new URLEvaluator();
        this.evaluator.setContext(this.context);
        this.evaluator.addURL("testUrl1");
        this.evaluator.start();
        this.request = new DummyRequest();
        this.response = new DummyResponse();
        this.serverAdapter = new DummyServerAdapter(this.request, this.response);
        super.setUp();
    }

    public void tearDown() throws Exception {
        this.evaluator.stop();
        this.evaluator = null;
        this.request = null;
        this.response = null;
        this.serverAdapter = null;
        this.context = null;
    }

    public void testExpectFalse() throws EvaluationException {
        this.request.setRequestUri("test");
        AccessEvent ae = new AccessEvent((HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        URLEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate((Object)ae));
    }

    public void testExpectTrue() throws EvaluationException {
        this.request.setRequestUri("testUrl1");
        AccessEvent ae = new AccessEvent((HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        URLEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate((Object)ae));
    }

    public void testExpectTrueMultiple() throws EvaluationException {
        this.evaluator.addURL("testUrl2");
        this.request.setRequestUri("testUrl2");
        AccessEvent ae = new AccessEvent((HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        URLEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate((Object)ae));
    }
}

