/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.net.MockSocketServer;
import ch.qos.logback.access.net.SocketAppender;
import ch.qos.logback.access.pattern.helpers.DummyRequest;
import ch.qos.logback.access.pattern.helpers.DummyResponse;
import ch.qos.logback.access.pattern.helpers.DummyServerAdapter;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.BasicContext;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;

public class SocketAppenderTest
extends TestCase {
    private BasicContext context;
    private MockSocketServer mockSocketServer;

    public void testStartFailNoRemoteHost() {
        this.context = new BasicContext();
        SocketAppender appender = new SocketAppender();
        appender.setContext((Context)this.context);
        appender.setPort(123);
        appender.start();
        SocketAppenderTest.assertEquals((int)1, (int)this.context.getStatusManager().getCount());
    }

    public void testRecieveMessage() throws InterruptedException {
        this.startServer(1);
        this.configureClient();
        this.context.callAppenders(this.buildNewAccessEvent());
        this.mockSocketServer.join(2000L);
        SocketAppenderTest.assertTrue((boolean)this.mockSocketServer.finished);
        SocketAppenderTest.assertEquals((int)1, (int)this.mockSocketServer.accessEventList.size());
        AccessEvent remoteEvent = this.mockSocketServer.accessEventList.get(0);
        SocketAppenderTest.assertEquals((String)"headerValue1", (String)remoteEvent.getRequestHeader("headerName1"));
        SocketAppenderTest.assertEquals((String)"testHost", (String)remoteEvent.getRemoteHost());
    }

    private void startServer(int expectedEventNumber) throws InterruptedException {
        this.mockSocketServer = new MockSocketServer(expectedEventNumber);
        this.mockSocketServer.start();
        Thread.sleep(100L);
    }

    private void configureClient() {
        this.context = new BasicContext();
        this.context.setName("test");
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setContext((Context)this.context);
        socketAppender.setName("socket");
        socketAppender.setPort(4560);
        socketAppender.setRemoteHost("localhost");
        this.context.addAppender((Appender)socketAppender);
        socketAppender.start();
    }

    private AccessEvent buildNewAccessEvent() {
        DummyRequest request = new DummyRequest();
        DummyResponse response = new DummyResponse();
        DummyServerAdapter adapter = new DummyServerAdapter(request, response);
        AccessEvent ae = new AccessEvent((HttpServletRequest)request, (HttpServletResponse)response, (ServerAdapter)adapter);
        return ae;
    }
}

