/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.db;

import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.db.DBAppenderBase;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAppender
extends DBAppenderBase<AccessEvent> {
    protected static final String insertSQL;
    protected final String insertHeaderSQL = "INSERT INTO  access_event_header (event_id, header_key, header_value) VALUES (?, ?, ?)";
    protected static final Method GET_GENERATED_KEYS_METHOD;
    private boolean insertHeaders = false;

    protected void subAppend(AccessEvent event, Connection connection, PreparedStatement insertStatement) throws Throwable {
        this.addAccessEvent(insertStatement, event);
        int updateCount = insertStatement.executeUpdate();
        if (updateCount != 1) {
            this.addWarn("Failed to insert access event");
        }
    }

    protected void secondarySubAppend(AccessEvent event, Connection connection, long eventId) throws Throwable {
        if (this.insertHeaders) {
            this.addRequestHeaders(event, connection, eventId);
        }
    }

    void addAccessEvent(PreparedStatement stmt, AccessEvent event) throws SQLException {
        stmt.setLong(1, event.getTimeStamp());
        stmt.setString(2, event.getRequestURI());
        stmt.setString(3, event.getRequestURL());
        stmt.setString(4, event.getRemoteHost());
        stmt.setString(5, event.getRemoteUser());
        stmt.setString(6, event.getRemoteAddr());
        stmt.setString(7, event.getProtocol());
        stmt.setString(8, event.getMethod());
        stmt.setString(9, event.getServerName());
        stmt.setString(10, event.getRequestContent());
    }

    void addRequestHeaders(AccessEvent event, Connection connection, long eventId) throws SQLException {
        Enumeration names = event.getRequestHeaderNames();
        if (names.hasMoreElements()) {
            PreparedStatement insertHeaderStatement = connection.prepareStatement("INSERT INTO  access_event_header (event_id, header_key, header_value) VALUES (?, ?, ?)");
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = event.getRequestHeader(key);
                insertHeaderStatement.setLong(1, eventId);
                insertHeaderStatement.setString(2, key);
                insertHeaderStatement.setString(3, value);
                if (this.cnxSupportsBatchUpdates) {
                    insertHeaderStatement.addBatch();
                    continue;
                }
                insertHeaderStatement.execute();
            }
            if (this.cnxSupportsBatchUpdates) {
                insertHeaderStatement.executeBatch();
            }
            insertHeaderStatement.close();
            insertHeaderStatement = null;
        }
    }

    protected Method getGeneratedKeysMethod() {
        return GET_GENERATED_KEYS_METHOD;
    }

    protected String getInsertSQL() {
        return insertSQL;
    }

    public void setInsertHeaders(boolean insertHeaders) {
        this.insertHeaders = insertHeaders;
    }

    static {
        Method getGeneratedKeysMethod;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO access_event (");
        sql.append("timestmp, ");
        sql.append("requestURI, ");
        sql.append("requestURL, ");
        sql.append("remoteHost, ");
        sql.append("remoteUser, ");
        sql.append("remoteAddr, ");
        sql.append("protocol, ");
        sql.append("method, ");
        sql.append("serverName, ");
        sql.append("postContent) ");
        sql.append(" VALUES (?, ?, ? ,?, ?, ?, ?, ?, ?, ?)");
        insertSQL = sql.toString();
        try {
            getGeneratedKeysMethod = PreparedStatement.class.getMethod("getGeneratedKeys", null);
        }
        catch (Exception ex) {
            getGeneratedKeysMethod = null;
        }
        GET_GENERATED_KEYS_METHOD = getGeneratedKeysMethod;
    }
}

