/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.PatternLayoutEncoder;
import ch.qos.logback.access.jetty.BasicHandler;
import ch.qos.logback.access.jetty.JettyFixtureBase;
import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.testUtil.NotifyingListAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import org.mortbay.jetty.Handler;

public class JettyFixture
extends JettyFixtureBase {
    Handler handler = new BasicHandler();

    public JettyFixture(RequestLogImpl impl, int port) {
        super(impl, port);
        this.url = "http://localhost:" + port + "/";
    }

    public void start() throws Exception {
        super.start();
        Thread.yield();
    }

    public void stop() throws Exception {
        super.stop();
        Thread.sleep(500L);
    }

    protected void buildContext() {
        NotifyingListAppender appender = new NotifyingListAppender();
        appender.setContext((Context)this.requestLogImpl);
        appender.setName("list");
        appender.start();
        ConsoleAppender console = new ConsoleAppender();
        console.setContext((Context)this.requestLogImpl);
        console.setName("console");
        PatternLayoutEncoder layout = new PatternLayoutEncoder();
        layout.setContext((Context)this.requestLogImpl);
        layout.setPattern("%date %server %clientHost");
        console.setEncoder((Encoder)layout);
        layout.start();
        console.start();
        this.requestLogImpl.addAppender((Appender)appender);
        this.requestLogImpl.addAppender((Appender)console);
    }

    protected Handler getHandler() {
        return this.handler;
    }
}

