/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.joran;

import ch.qos.logback.access.dummy.DummyAccessEventBuilder;
import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.StringListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JoranConfiguratorTest {
    AccessContext context = new AccessContext();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(file);
    }

    @Test
    public void smoke() throws Exception {
        this.configure("src/test/input/joran/smoke.xml");
        ListAppender listAppender = (ListAppender)this.context.getAppender("LIST");
        AccessEvent event = DummyAccessEventBuilder.buildNewAccessEvent();
        listAppender.doAppend((Object)event);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        AccessEvent ae = (AccessEvent)listAppender.list.get(0);
        Assert.assertNotNull((Object)ae);
    }

    @Test
    public void defaultLayout() throws Exception {
        this.configure("src/test/input/joran/defaultLayout.xml");
        StringListAppender listAppender = (StringListAppender)this.context.getAppender("STR_LIST");
        AccessEvent event = DummyAccessEventBuilder.buildNewAccessEvent();
        listAppender.doAppend((Object)event);
        Assert.assertEquals((long)1L, (long)listAppender.strList.size());
        Assert.assertTrue((boolean)((String)listAppender.strList.get(0)).startsWith("testMethod"));
    }
}

