/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.sift;

import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.sift.JettyFixture;
import ch.qos.logback.access.sift.SiftingAppender;
import ch.qos.logback.access.spi.Util;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SiftingAppenderTest {
    static final String PREFIX = "src/test/input/jetty/";
    static int RANDOM_SERVER_PORT = RandomUtil.getRandomServerPort();
    JettyFixture jettyFixture;
    RequestLogImpl rli = new RequestLogImpl();

    @Before
    public void startServer() throws Exception {
        this.jettyFixture = new JettyFixture(this.rli, RANDOM_SERVER_PORT);
    }

    @After
    public void stopServer() throws Exception {
        if (this.jettyFixture != null) {
            this.jettyFixture.stop();
        }
    }

    @Test
    public void test() throws Exception {
        this.rli.setFileName("src/test/input/jetty/sifting.xml");
        this.jettyFixture.start();
        StatusPrinter.print((Context)this.rli);
        this.invokeServer("/");
        this.invokeServer("/x");
        this.invokeServer("/x");
        this.invokeServer("/y");
        SiftingAppender siftingAppender = (SiftingAppender)this.rli.getAppender("SIFTING");
        List keyList = siftingAppender.getAppenderTracker().keyList();
        Assert.assertEquals((long)3L, (long)keyList.size());
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("NA");
        witnessList.add("x");
        witnessList.add("y");
        Assert.assertEquals(witnessList, (Object)keyList);
        long now = System.currentTimeMillis();
        ListAppender listAppender = (ListAppender)siftingAppender.getAppenderTracker().get("NA", now);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        listAppender = (ListAppender)siftingAppender.getAppenderTracker().get("x", now);
        Assert.assertEquals((long)2L, (long)listAppender.list.size());
        listAppender = (ListAppender)siftingAppender.getAppenderTracker().get("y", now);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
    }

    void invokeServer(String uri) throws Exception {
        URL url = new URL("http://localhost:" + RANDOM_SERVER_PORT + uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        Util.readToString((InputStream)connection.getInputStream());
        Thread.sleep(30L);
    }
}

