/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.html;

import ch.qos.logback.access.PatternLayout;
import ch.qos.logback.access.html.DefaultCssBuilder;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.html.HTMLLayoutBase;
import ch.qos.logback.core.html.NOPThrowableRenderer;
import ch.qos.logback.core.pattern.Converter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLLayout
extends HTMLLayoutBase<AccessEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%h%l%u%t%r%s%b";

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new NOPThrowableRenderer();
        this.cssBuilder = new DefaultCssBuilder();
    }

    protected Map<String, String> getDefaultConverterMap() {
        return PatternLayout.defaultConverterMap;
    }

    public String doLayout(AccessEvent event) {
        StringBuilder buf = new StringBuilder();
        this.startNewTableIfLimitReached(buf);
        boolean odd = true;
        if ((this.counter++ & 1L) == 0L) {
            odd = false;
        }
        buf.append(CoreConstants.LINE_SEPARATOR);
        buf.append("<tr class=\"");
        if (odd) {
            buf.append(" odd\">");
        } else {
            buf.append(" even\">");
        }
        buf.append(CoreConstants.LINE_SEPARATOR);
        for (Converter c = this.head; c != null; c = c.getNext()) {
            this.appendEventToBuffer(buf, (Converter<AccessEvent>)c, event);
        }
        buf.append("</tr>");
        buf.append(CoreConstants.LINE_SEPARATOR);
        return buf.toString();
    }

    private void appendEventToBuffer(StringBuilder buf, Converter<AccessEvent> c, AccessEvent event) {
        buf.append("<td class=\"");
        buf.append(this.computeConverterName(c));
        buf.append("\">");
        buf.append(c.convert((Object)event));
        buf.append("</td>");
        buf.append(CoreConstants.LINE_SEPARATOR);
    }
}

