/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access;

import ch.qos.logback.access.pattern.ContentLengthConverter;
import ch.qos.logback.access.pattern.DateConverter;
import ch.qos.logback.access.pattern.LineSeparatorConverter;
import ch.qos.logback.access.pattern.LocalIPAddressConverter;
import ch.qos.logback.access.pattern.LocalPortConverter;
import ch.qos.logback.access.pattern.NAConverter;
import ch.qos.logback.access.pattern.RemoteHostConverter;
import ch.qos.logback.access.pattern.RemoteIPAddressConverter;
import ch.qos.logback.access.pattern.RemoteUserConverter;
import ch.qos.logback.access.pattern.RequestAttributeConverter;
import ch.qos.logback.access.pattern.RequestCookieConverter;
import ch.qos.logback.access.pattern.RequestHeaderConverter;
import ch.qos.logback.access.pattern.RequestMethodConverter;
import ch.qos.logback.access.pattern.RequestParameterConverter;
import ch.qos.logback.access.pattern.RequestProtocolConverter;
import ch.qos.logback.access.pattern.RequestURIConverter;
import ch.qos.logback.access.pattern.RequestURLConverter;
import ch.qos.logback.access.pattern.ResponseHeaderConverter;
import ch.qos.logback.access.pattern.ServerNameConverter;
import ch.qos.logback.access.pattern.StatusCodeConverter;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternLayout
extends PatternLayoutBase<AccessEvent> {
    public static final Map<String, String> defaultConverterMap = new HashMap<String, String>();
    public static String CLF_PATTERN = "%h %l %u %t \"%r\" %s %b";
    public static String CLF_PATTERN_NAME = "common";
    public static String CLF_PATTERN_NAME_2 = "clf";
    public static String COMBINED_PATTERN = "%h %l %u %t \"%r\" %s %b \"%i{Referer}\" \"%i{User-Agent}\"";
    public static String COMBINED_PATTERN_NAME = "combined";

    public PatternLayout() {
        this.setPattern(CLF_PATTERN);
    }

    public Map<String, String> getDefaultConverterMap() {
        return defaultConverterMap;
    }

    protected void postCompileProcessing(Converter<AccessEvent> head) {
        Converter tail = this.findTail((Converter)head);
        LineSeparatorConverter newLineConverter = new LineSeparatorConverter();
        if (tail == null) {
            head = newLineConverter;
        } else if (!(tail instanceof LineSeparatorConverter)) {
            tail.setNext((Converter)newLineConverter);
        }
        this.setContextForConverters((Converter)head);
    }

    public String doLayout(AccessEvent event) {
        if (!this.isStarted()) {
            return null;
        }
        return this.writeLoopOnConverters(event);
    }

    public void start() {
        if (this.getPattern().equalsIgnoreCase(CLF_PATTERN_NAME) || this.getPattern().equalsIgnoreCase(CLF_PATTERN_NAME_2)) {
            this.setPattern(CLF_PATTERN);
        } else if (this.getPattern().equalsIgnoreCase(COMBINED_PATTERN_NAME)) {
            this.setPattern(COMBINED_PATTERN);
        }
        super.start();
    }

    static {
        defaultConverterMap.put("a", RemoteIPAddressConverter.class.getName());
        defaultConverterMap.put("remoteIP", RemoteIPAddressConverter.class.getName());
        defaultConverterMap.put("A", LocalIPAddressConverter.class.getName());
        defaultConverterMap.put("localIP", LocalIPAddressConverter.class.getName());
        defaultConverterMap.put("b", ContentLengthConverter.class.getName());
        defaultConverterMap.put("B", ContentLengthConverter.class.getName());
        defaultConverterMap.put("bytesSent", ContentLengthConverter.class.getName());
        defaultConverterMap.put("h", RemoteHostConverter.class.getName());
        defaultConverterMap.put("clientHost", RemoteHostConverter.class.getName());
        defaultConverterMap.put("H", RequestProtocolConverter.class.getName());
        defaultConverterMap.put("protocol", RequestProtocolConverter.class.getName());
        defaultConverterMap.put("i", RequestHeaderConverter.class.getName());
        defaultConverterMap.put("header", RequestHeaderConverter.class.getName());
        defaultConverterMap.put("l", NAConverter.class.getName());
        defaultConverterMap.put("m", RequestMethodConverter.class.getName());
        defaultConverterMap.put("requestMethod", RequestMethodConverter.class.getName());
        defaultConverterMap.put("r", RequestURLConverter.class.getName());
        defaultConverterMap.put("requestURL", RequestURLConverter.class.getName());
        defaultConverterMap.put("s", StatusCodeConverter.class.getName());
        defaultConverterMap.put("statusCode", StatusCodeConverter.class.getName());
        defaultConverterMap.put("t", DateConverter.class.getName());
        defaultConverterMap.put("date", DateConverter.class.getName());
        defaultConverterMap.put("u", RemoteUserConverter.class.getName());
        defaultConverterMap.put("user", RemoteUserConverter.class.getName());
        defaultConverterMap.put("U", RequestURIConverter.class.getName());
        defaultConverterMap.put("requestURI", RequestURIConverter.class.getName());
        defaultConverterMap.put("v", ServerNameConverter.class.getName());
        defaultConverterMap.put("server", ServerNameConverter.class.getName());
        defaultConverterMap.put("localPort", LocalPortConverter.class.getName());
        defaultConverterMap.put("reqAttribute", RequestAttributeConverter.class.getName());
        defaultConverterMap.put("reqCookie", RequestCookieConverter.class.getName());
        defaultConverterMap.put("responseHeader", ResponseHeaderConverter.class.getName());
        defaultConverterMap.put("reqParameter", RequestParameterConverter.class.getName());
        defaultConverterMap.put("n", LineSeparatorConverter.class.getName());
    }
}

