/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.mongodb;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MongoDBAppenderBase<E>
extends UnsynchronizedAppenderBase<E> {
    private Mongo mongo = null;
    private DBCollection eventsCollection = null;
    private String uri = null;

    public void start() {
        try {
            if (this.uri == null) {
                this.addError("Please set a non-null MongoDB URI.");
                return;
            }
            MongoURI mongoURI = new MongoURI(this.uri);
            String database = mongoURI.getDatabase();
            String collection = mongoURI.getCollection();
            if (database == null || collection == null) {
                this.addError("Error connecting to MongoDB URI: " + this.uri + " must contain a database and a collection." + " E.g. mongodb://localhost/database.collection");
                return;
            }
            this.mongo = new Mongo(mongoURI);
            DB db = this.mongo.getDB(database);
            String username = mongoURI.getUsername();
            char[] password = mongoURI.getPassword();
            if (username != null && password != null) {
                db.authenticate(username, password);
            }
            this.eventsCollection = db.getCollection(collection);
            super.start();
        }
        catch (Exception exception) {
            this.addError("Error connecting to MongoDB URI: " + this.uri, exception);
        }
    }

    protected void append(E event) {
        this.eventsCollection.insert(new DBObject[]{this.toMongoDocument(event)});
    }

    protected abstract BasicDBObject toMongoDocument(E var1);

    public void stop() {
        if (this.mongo != null) {
            this.mongo.close();
        }
        super.stop();
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

