/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.server;

import ch.qos.logback.audit.persistent.Persistor;
import ch.qos.logback.audit.server.AuditServerConstants;
import ch.qos.logback.audit.server.helper.ResourceUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCreator {
    Logger logger = LoggerFactory.getLogger(TableCreator.class);
    Configuration cfg;

    public TableCreator(Configuration cfg) {
        this.cfg = cfg;
    }

    public void createTables(String filename) {
        SchemaExport schemaExport = new SchemaExport(this.cfg);
        boolean printDLL = false;
        if (filename != null) {
            schemaExport.setOutputFile(filename);
            printDLL = true;
        }
        schemaExport.create(printDLL, true);
    }

    public void createTables() {
        this.createTables(null);
    }

    public static void main(String[] args) throws IOException {
        Configuration cfg = Persistor.createConfiguration();
        Properties props = ResourceUtil.getProps("tmp/hibernate.properties");
        cfg.setProperties(props);
        TableCreator tc = new TableCreator(cfg);
        tc.createTables("src/test/sql/audit_tables.sql-" + AuditServerConstants.ISODATE_SDF.format(new Date()));
    }
}

