/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.server;

import ch.qos.logback.audit.AuditEvent;
import ch.qos.logback.audit.server.AuditEventHandler;
import ch.qos.logback.audit.server.AuditServer;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketNode
implements Runnable {
    final AuditServer auditServer;
    final Socket socket;
    final AuditEventHandler aeh;
    ObjectOutputStream oos;
    ObjectInputStream ois;
    int writeCount = 0;
    boolean closed = false;
    static final int RESET_FREQUENCY = 1000;
    static Logger logger = LoggerFactory.getLogger(SocketNode.class);

    public SocketNode(AuditServer auditServer, Socket socket, AuditEventHandler aeh) {
        this.auditServer = auditServer;
        this.socket = socket;
        this.aeh = aeh;
        try {
            this.ois = new ObjectInputStream(socket.getInputStream());
            this.oos = new ObjectOutputStream(socket.getOutputStream());
        }
        catch (Exception e) {
            logger.error("Could not open ObjectInputStream to " + socket, (Throwable)e);
        }
    }

    void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ois != null) {
            try {
                this.ois.close();
                this.ois = null;
            }
            catch (IOException e) {
                logger.warn("While in close method caught: " + e.getMessage());
            }
        }
    }

    public void run() {
        AuditEvent event = null;
        while (!this.closed) {
            Serializable outgoingObject;
            try {
                event = (AuditEvent)this.ois.readObject();
            }
            catch (EOFException e) {
                logger.info("Caught java.io.EOFException closing connection.");
                break;
            }
            catch (IOException e) {
                logger.info("Caught: " + e.getMessage());
                break;
            }
            catch (ClassNotFoundException e) {
                logger.error("Unexpected ClassNotFoundException.", (Throwable)e);
                this.writeResponse(e);
                break;
            }
            try {
                this.aeh.doHandle(event);
                outgoingObject = new Boolean(true);
            }
            catch (Exception e) {
                logger.error("Problem while handling audit event", (Throwable)e);
                outgoingObject = e;
            }
            logger.trace("Outgoing object is {}", (Object)outgoingObject);
            this.writeResponse(outgoingObject);
        }
        this.auditServer.socketNodeClosing(this);
    }

    private void writeResponse(Object outgoingObject) {
        try {
            if (this.writeCount++ >= 1000) {
                this.writeCount = 0;
                System.out.print("r");
                this.oos.reset();
            }
            this.oos.writeObject(outgoingObject);
        }
        catch (IOException e) {
            logger.error("Failed to send acknowledgement", (Throwable)e);
        }
    }

    public String toString() {
        if (this.socket != null) {
            return "SocketNode to " + this.socket.getRemoteSocketAddress();
        }
        return "SocketNode to null socket";
    }
}

