/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.persistent;

import ch.qos.logback.audit.AuditEvent;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persistor {
    static SessionFactory sessionFactory;
    static Configuration cfg;
    static Object cfgLock;
    static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SessionFactory getSessionFactory() throws HibernateException {
        if (sessionFactory != null) return sessionFactory;
        Class<SessionFactory> clazz = SessionFactory.class;
        synchronized (SessionFactory.class) {
            if (sessionFactory != null) return sessionFactory;
            sessionFactory = Persistor.createSessionFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sessionFactory;
        }
    }

    public static Configuration createConfiguration() {
        Configuration cfg = new Configuration();
        cfg.addClass(AuditEvent.class);
        return cfg;
    }

    public static void setConfiguration(Configuration cfg, Object lock) {
        if (cfgLock == null && lock != null) {
            cfgLock = lock;
        }
        if (cfgLock == null || cfgLock.equals(lock)) {
            Persistor.cfg = cfg;
        } else if (Persistor.cfg == null) {
            Persistor.cfg = cfg;
        } else {
            throw new IllegalStateException("Configuration was already set.");
        }
    }

    public static void resetConfiguration(Object lock) {
        if (cfgLock == null || cfgLock.equals(lock)) {
            cfg = null;
            if (sessionFactory != null) {
                try {
                    sessionFactory.close();
                }
                catch (HibernateException he) {
                    logger.error("Warn failed to close session factory", (Throwable)he);
                }
            }
            sessionFactory = null;
        }
    }

    static SessionFactory createSessionFactory() {
        if (cfg == null) {
            throw new IllegalStateException("Configuration must be set before usage.");
        }
        return cfg.buildSessionFactory();
    }

    protected static Session openSession() throws HibernateException {
        SessionFactory sessionFactory = Persistor.getSessionFactory();
        return sessionFactory.openSession();
    }

    protected static void update(Object o) throws HibernateException {
        Session s = null;
        Transaction tx = null;
        try {
            s = Persistor.openSession();
            tx = s.beginTransaction();
            s.update(o);
            tx.commit();
        }
        catch (HibernateException he) {
            if (tx != null) {
                tx.rollback();
            }
            throw he;
        }
        finally {
            Persistor.close(s, tx);
        }
    }

    public static void save(Object o) throws HibernateException {
        Session s = null;
        Transaction tx = null;
        try {
            s = Persistor.openSession();
            tx = s.beginTransaction();
            s.save(o);
            tx.commit();
        }
        catch (HibernateException he) {
            logger.error("Failed to save object", (Throwable)he);
            if (tx != null) {
                tx.rollback();
            }
            throw he;
        }
        finally {
            Persistor.close(s, tx);
        }
    }

    private static Logger getStaticLogger() {
        return LoggerFactory.getLogger(Persistor.class);
    }

    public static void delete(Object o) throws HibernateException {
        Session s = null;
        Transaction tx = null;
        try {
            s = Persistor.openSession();
            tx = s.beginTransaction();
            s.delete(o);
            tx.commit();
        }
        catch (HibernateException he) {
            if (tx != null) {
                tx.rollback();
            }
            throw he;
        }
        finally {
            Persistor.close(s, tx);
        }
    }

    protected static void close(Session theHibernateSession) {
        try {
            if (theHibernateSession != null) {
                theHibernateSession.close();
            }
        }
        catch (Exception e) {
            Persistor.getStaticLogger().error("Failed to close session " + theHibernateSession, (Throwable)e);
        }
    }

    protected static void close(Session theHibernateSession, Transaction tx) {
        try {
            if (tx != null && tx.isActive() && !tx.wasCommitted()) {
                tx.rollback();
            }
        }
        catch (HibernateException he) {
            Persistor.getStaticLogger().error("Could not rollback transaction" + tx);
        }
        try {
            if (theHibernateSession != null) {
                theHibernateSession.close();
            }
        }
        catch (Exception e) {
            Persistor.getStaticLogger().error("Failed to close session " + theHibernateSession, (Throwable)e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(Persistor.class);
    }
}

