/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.client.net;

import ch.qos.logback.audit.AuditEvent;
import ch.qos.logback.audit.AuditException;
import ch.qos.logback.audit.client.AuditAppenderBase;
import ch.qos.logback.audit.client.net.Connector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class SocketAuditAppender
extends AuditAppenderBase {
    static final String NO_HOST_URL = "http://audit.qos.ch/codes.html#NO_HOST_URL";
    static final String FAILIED_WRITE_URL = "http://audit.qos.ch/codes.html#FAILIED_WRITE_URL";
    static final int DEFAULT_PORT = 9630;
    private String remoteHost;
    private InetAddress address;
    private int port = 9630;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private int reconnectionDelay = 2000;
    protected int counter = 0;
    private static final int RESET_FREQUENCY = 200;
    Connector connector;

    public void start() {
        int errorCount = 0;
        if (this.port == 0) {
            ++errorCount;
            this.addError("No port was configured for appender" + this.name);
        }
        if (this.address == null) {
            ++errorCount;
            this.addError("No remote address was configured for appender " + this.name);
        }
        if (errorCount == 0) {
            this.connect(this.address, this.port);
        }
    }

    public void stop() {
        super.stop();
        this.cleanUp();
        if (this.connector != null) {
            this.connector.setClosed(true);
            Thread connectorThread = this.connector.getThread();
            try {
                connectorThread.join(5000L);
            }
            catch (InterruptedException e) {
                this.addError("Failed to join connector thread", e);
            }
            this.connector = null;
        }
    }

    void connect(Socket socket) {
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.ois = new ObjectInputStream(socket.getInputStream());
            this.started = true;
        }
        catch (IOException e) {
            String msg = "Failed to open a stream on the socket for remmote logback server at [" + this.address.getHostName() + "] at port " + this.port;
            this.addError(msg, e);
        }
    }

    void connect(InetAddress address, int port) {
        block2: {
            try {
                this.cleanUp();
                Socket socket = new Socket(address, port);
                this.connect(socket);
            }
            catch (IOException e) {
                String msg = "Could not connect to remote logback server at [" + address.getHostName() + "] at port " + port;
                this.addError(msg, e);
                if (this.reconnectionDelay <= 0) break block2;
                this.fireConnector();
            }
        }
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                this.addError("Could not close oos.", e);
            }
            this.oos = null;
        }
        if (this.ois != null) {
            try {
                this.ois.close();
            }
            catch (IOException e) {
                this.addError("Could not close oos.", e);
            }
            this.ois = null;
        }
    }

    protected void append(AuditEvent auditEvent) throws AuditException {
        block13: {
            if (!this.started) {
                return;
            }
            if (auditEvent == null) {
                return;
            }
            if (this.oos != null) {
                try {
                    this.oos.writeObject(auditEvent);
                    this.oos.flush();
                    if (++this.counter >= 200) {
                        this.counter = 0;
                        this.oos.reset();
                    }
                }
                catch (IOException e) {
                    this.oos = null;
                    this.started = false;
                    this.fireConnector();
                    throw new AuditException("Failed sending audit event to host \"" + this.remoteHost + "\" down. For more information, please visit " + FAILIED_WRITE_URL, (Throwable)e);
                }
            }
            try {
                Object incoming = this.ois.readObject();
                if (incoming instanceof Exception) {
                    if (incoming instanceof AuditException) {
                        AuditException ae = (AuditException)incoming;
                        throw ae;
                    }
                    throw new AuditException("Server incurred an exception", (Throwable)((Exception)incoming));
                }
                if (incoming instanceof Boolean) {
                    Boolean ack = (Boolean)incoming;
                    if (!ack.booleanValue()) {
                        throw new AuditException("Acknowledgement failure");
                    }
                    break block13;
                }
                throw new AuditException("Incoming object [" + incoming + "] outside of protocol");
            }
            catch (IOException e) {
                throw new AuditException("Failed reading acknowledgement", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new AuditException("Unexpecteed object type while acknowledgement", (Throwable)e);
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    protected static InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            return null;
        }
    }

    void fireConnector() {
        if (this.connector == null) {
            this.addInfo("Firing a connector thread");
            this.connector = new Connector(this);
            this.connector.setContext(this.getContext());
            Thread connectorThread = new Thread(this.connector);
            connectorThread.setDaemon(true);
            connectorThread.setName("SAA-ConnectorThread");
            connectorThread.setPriority(1);
            this.connector.setThread(connectorThread);
            connectorThread.start();
        }
    }

    InetAddress getAddress() {
        return this.address;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setReconnectionDelay(int reconnectionDelay) {
        this.reconnectionDelay = reconnectionDelay;
    }

    public void setRemoteHost(String host) {
        this.address = SocketAuditAppender.getAddressByName(host);
        this.remoteHost = host;
    }
}

