/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.client.joran.action;

import ch.qos.logback.audit.client.AuditAppender;
import ch.qos.logback.audit.client.Auditor;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class AuditAppenderAction
extends Action {
    AuditAppender auditAppender;
    private boolean inError = false;

    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        String className = attributes.getValue("class");
        this.auditAppender = null;
        this.inError = false;
        try {
            this.addInfo("About to instantiate appender of type [" + className + "]");
            this.auditAppender = (AuditAppender)OptionHelper.instantiateByClassName((String)className, AuditAppender.class, (Context)this.context);
            this.auditAppender.setContext(this.context);
            String appenderName = attributes.getValue("name");
            if (OptionHelper.isEmpty((String)appenderName)) {
                this.addWarn("No appender name given for appender of type " + className + "].");
            } else {
                this.auditAppender.setName(appenderName);
                this.addInfo("Naming appender as [" + appenderName + "]");
            }
            ec.pushObject((Object)this.auditAppender);
        }
        catch (Exception oops) {
            this.inError = true;
            this.addError("Could not create an Appender of type [" + className + "].", oops);
            throw new ActionException((Throwable)oops);
        }
    }

    public void end(InterpretationContext ec, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Object o = ec.peekObject();
        if (o != this.auditAppender) {
            this.addWarn("The object at the of the stack is not the appender named [" + this.auditAppender.getName() + "] pushed earlier.");
        } else {
            this.addInfo("Popping appender named [" + this.auditAppender.getName() + "] from the object stack");
            ec.popObject();
        }
        this.addInfo("Setting auditor's appender to appender named [" + this.auditAppender.getName() + "]");
        if (this.auditAppender instanceof LifeCycle) {
            this.auditAppender.start();
        }
        Auditor ac = (Auditor)this.context;
        ac.setAuditAppender(this.auditAppender);
    }
}

