/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.client;

import ch.qos.logback.audit.Application;
import ch.qos.logback.audit.AuditException;
import ch.qos.logback.audit.client.Auditor;
import ch.qos.logback.audit.client.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;

public class AuditorFactory {
    static final String DEFAULT_AUDITOR_NAME = "default";
    static final String AUTOCONFIG_FILE = "logback-audit.xml";
    static final String TEST_AUTOCONFIG_FILE = "logback-audit-test.xml";
    public static final String AUTOCONFIG_FILE_PROPERTY = "logback.audit.autoconfig.file";
    public static final String NULL_CLIENT_APPLICATON_URL = "http://audit.qos.ch/codes.html#nullClientApp";
    public static final String NULL_AUDIT_APPENDER_URL = "http://audit.qos.ch/codes.html#nullAuditAppender";
    static Auditor defaultAuditor;
    static Application clientApplication;

    static void checkSanity(Auditor auditor) throws AuditException {
        StatusManager sm = auditor.getStatusManager();
        StatusChecker checker = new StatusChecker(sm);
        if (checker.getHighestLevel(0L) > 0) {
            StatusPrinter.print((StatusManager)sm);
        }
        if (auditor.getClientApplication() == null) {
            throw new AuditException("Client application has not been set");
        }
        if (auditor.getAuditAppender() == null) {
            throw new AuditException("No audit appender. Please see http://audit.qos.ch/codes.html#nullAuditAppender");
        }
    }

    public static void setApplicationName(String name) throws AuditException {
        if (clientApplication != null && clientApplication.getName().equals(name)) {
            return;
        }
        if (clientApplication != null && !clientApplication.getName().equals(name)) {
            throw new IllegalStateException("Application name " + clientApplication.getName() + " once set cannot be renamed.");
        }
        if (OptionHelper.isEmpty((String)name)) {
            throw new IllegalArgumentException("Application name cannot be null or empty");
        }
        try {
            Application aplication;
            InetAddress address = InetAddress.getLocalHost();
            String fqdn = address.getCanonicalHostName();
            clientApplication = aplication = new Application(name, fqdn);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Failed to determine the hostname for this host", e);
        }
        defaultAuditor = new Auditor();
        defaultAuditor.setClientApplication(clientApplication);
        defaultAuditor.setName(DEFAULT_AUDITOR_NAME);
        AuditorFactory.autoConfig(defaultAuditor);
        AuditorFactory.checkSanity(defaultAuditor);
    }

    public static Auditor getAuditor() {
        return defaultAuditor;
    }

    public static void autoConfig(Auditor auditor) throws AuditException {
        ClassLoader tccl = Loader.getTCL();
        AuditorFactory.autoConfig(auditor, tccl);
    }

    public static void configureByResource(Auditor auditor, URL url) throws AuditException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)auditor);
        try {
            configurator.doConfigure(url);
        }
        catch (JoranException e) {
            throw new AuditException("Configuration failure in " + url, (Throwable)e);
        }
    }

    public static void autoConfig(Auditor auditor, ClassLoader classLoader) throws AuditException {
        String autoConfigFileByProperty = System.getProperty(AUTOCONFIG_FILE_PROPERTY);
        String pathPrefix = clientApplication.getName() + "/";
        URL url = null;
        if (autoConfigFileByProperty != null) {
            url = Loader.getResource((String)(pathPrefix + autoConfigFileByProperty), (ClassLoader)classLoader);
        } else {
            url = Loader.getResource((String)(pathPrefix + TEST_AUTOCONFIG_FILE), (ClassLoader)classLoader);
            if (url == null) {
                url = Loader.getResource((String)(pathPrefix + AUTOCONFIG_FILE), (ClassLoader)classLoader);
            }
        }
        if (url == null) {
            String errMsg = autoConfigFileByProperty != null ? "Failed to find configuration file [" + pathPrefix + autoConfigFileByProperty + "]." : "Failed to find logback-audit configuration files  [" + pathPrefix + TEST_AUTOCONFIG_FILE + "] or [" + pathPrefix + AUTOCONFIG_FILE + "].";
            throw new AuditException(errMsg);
        }
        AuditorFactory.configureByResource(auditor, url);
    }

    public static void reset() {
        clientApplication = null;
        if (defaultAuditor != null) {
            defaultAuditor.shutdown();
        }
        defaultAuditor = null;
    }
}

