/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.client;

import ch.qos.logback.audit.Application;
import ch.qos.logback.audit.AuditEventBuilder;
import ch.qos.logback.audit.AuditException;
import ch.qos.logback.audit.Predicate;
import ch.qos.logback.audit.client.Auditor;
import ch.qos.logback.audit.client.AuditorFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditorFacade {
    final Logger logger = LoggerFactory.getLogger(AuditorFacade.class);
    final String object;
    final String verb;
    final String subject;
    Application originatingApplication;
    Map<String, String> predicateMap;

    public AuditorFacade(String subject, String verb, String object) {
        this.subject = subject;
        this.verb = verb;
        this.object = object;
    }

    public void audit() throws AuditException {
        Auditor auditor = AuditorFactory.getAuditor();
        AuditEventBuilder builder = auditor.newAuditEventBuilder();
        builder.setObject(this.object);
        builder.setVerb(this.verb);
        builder.setSubject(this.subject);
        if (this.predicateMap != null) {
            builder.setPredicateMap(this.predicateMap);
        }
        if (this.originatingApplication != null) {
            builder.setOriginatingApplication(this.originatingApplication);
        }
        auditor.log(builder);
    }

    public AuditorFacade setPredicateMap(Map<String, String> predicateMap) {
        this.predicateMap = predicateMap;
        return this;
    }

    public AuditorFacade add(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate parameter cannot be null");
        }
        return this.add(predicate.getName(), predicate.getValue());
    }

    public AuditorFacade add(String key, String value) {
        if (this.predicateMap == null) {
            this.predicateMap = new HashMap<String, String>();
        }
        this.predicateMap.put(key, value);
        return this;
    }

    public AuditorFacade originating(Application originatingApplication) {
        this.originatingApplication = originatingApplication;
        return this;
    }
}

