/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.client;

import ch.qos.logback.audit.Application;
import ch.qos.logback.audit.AuditEvent;
import ch.qos.logback.audit.AuditEventBuilder;
import ch.qos.logback.audit.AuditEventBuilderImpl;
import ch.qos.logback.audit.AuditException;
import ch.qos.logback.audit.client.AuditAppender;
import ch.qos.logback.core.ContextBase;

public class Auditor
extends ContextBase {
    AuditAppender auditAppender;
    Application clientApplication;

    public AuditEventBuilder newAuditEventBuilder() {
        AuditEventBuilderImpl ab = new AuditEventBuilderImpl();
        ab.setClientApplication(this.clientApplication);
        return ab;
    }

    public void log(AuditEvent auditEvent) throws AuditException {
        this.auditAppender.doAppend(auditEvent);
    }

    public void log(AuditEventBuilder builder) throws AuditException {
        AuditEvent auditEvent = builder.build();
        this.auditAppender.doAppend(auditEvent);
    }

    public AuditAppender getAuditAppender() {
        return this.auditAppender;
    }

    public void setAuditAppender(AuditAppender auditAppender) {
        this.auditAppender = auditAppender;
    }

    public void shutdown() {
        if (this.auditAppender != null) {
            this.auditAppender.stop();
        }
        this.auditAppender = null;
    }

    public Application getClientApplication() {
        return this.clientApplication;
    }

    public void setClientApplication(Application capp) {
        if (this.clientApplication != null) {
            throw new IllegalStateException("Client application has been set already.");
        }
        this.clientApplication = capp;
    }
}

