/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.audit.client;

import ch.qos.logback.audit.AuditEvent;
import ch.qos.logback.audit.AuditException;
import ch.qos.logback.audit.client.AuditAppender;
import ch.qos.logback.core.spi.ContextAwareBase;

public abstract class AuditAppenderBase
extends ContextAwareBase
implements AuditAppender {
    protected boolean started = false;
    protected String name;

    public synchronized void doAppend(AuditEvent auditEvent) throws AuditException {
        try {
            if (!this.started) {
                throw new AuditException("Attempted to append to non started appender [" + this.name + "].");
            }
            this.append(auditEvent);
        }
        catch (Exception e) {
            if (e instanceof AuditException) {
                throw (AuditException)e;
            }
            throw new AuditException("Failed to audit an event", (Throwable)e);
        }
    }

    protected abstract void append(AuditEvent var1) throws AuditException;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }
}

