/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.sample.Colors;
import ch.qos.cal10n.util.AnnotationExtractor;
import ch.qos.cal10n.util.CAL10NResourceBundleFinder;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.junit.Assert;
import org.junit.Test;

public class CAL10NResourceBundleFinderTest {
    ResourceBundle rb;
    String encoding;
    AnnotationExtractor annotationExtractor = new AnnotationExtractor(Colors.class);

    @Test
    public void smoke() throws IOException {
        this.encoding = this.annotationExtractor.extractCharset(Locale.FRENCH);
        this.rb = CAL10NResourceBundleFinder.getBundle((ClassLoader)this.getClass().getClassLoader(), (String)"colors", (Locale)Locale.FRENCH, (String)this.encoding);
        Assert.assertEquals((Object)"les roses sont rouges", (Object)this.rb.getString("RED"));
    }

    @Test
    public void withCountry() throws IOException {
        this.encoding = this.annotationExtractor.extractCharset(Locale.FRENCH);
        this.rb = CAL10NResourceBundleFinder.getBundle((ClassLoader)this.getClass().getClassLoader(), (String)"colors", (Locale)Locale.FRENCH, (String)this.encoding);
        Assert.assertEquals((Object)"les roses sont rouges", (Object)this.rb.getString("RED"));
        this.rb = CAL10NResourceBundleFinder.getBundle((ClassLoader)this.getClass().getClassLoader(), (String)"colors", (Locale)Locale.FRANCE, (String)this.encoding);
        Assert.assertEquals((Object)"les roses sont rouges, et alors?", (Object)this.rb.getString("RED"));
    }

    @Test
    public void inDirectory() throws IOException {
        this.encoding = this.annotationExtractor.extractCharset(Locale.ENGLISH);
        this.rb = CAL10NResourceBundleFinder.getBundle((ClassLoader)this.getClass().getClassLoader(), (String)"foobar/sample", (Locale)Locale.ENGLISH, (String)this.encoding);
        Assert.assertEquals((Object)"A is the first letter of the alphabet", (Object)this.rb.getString("A"));
        this.rb = CAL10NResourceBundleFinder.getBundle((ClassLoader)this.getClass().getClassLoader(), (String)"foobar.sample", (Locale)Locale.ENGLISH, (String)this.encoding);
        Assert.assertEquals((Object)"A is the first letter of the alphabet", (Object)this.rb.getString("A"));
    }
}

