/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.CAL10NTestConstants;
import ch.qos.cal10n.util.Token;
import ch.qos.cal10n.util.TokenStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.junit.Assert;
import org.junit.Test;

public class TokenStreamTest {
    @Test
    public void smoke() throws FileNotFoundException {
        FileReader fr = new FileReader(CAL10NTestConstants.TEST_CLASSES + "/parser/smoke.properties");
        TokenStream ts = new TokenStream((Reader)fr);
        List tokenList = ts.tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(Token.TokenType.KEY, "K0"));
        witness.add(new Token(Token.TokenType.SEPARATOR, "="));
        witness.add(new Token(Token.TokenType.VALUE, "V0"));
        witness.add(Token.EOL);
        witness.add(new Token(Token.TokenType.KEY, "K1"));
        witness.add(new Token(Token.TokenType.SEPARATOR, "="));
        witness.add(new Token(Token.TokenType.VALUE, "V1"));
        witness.add(Token.EOL);
        Assert.assertEquals(witness, (Object)tokenList);
    }

    @Test
    public void medium() throws FileNotFoundException {
        FileReader fr = new FileReader(CAL10NTestConstants.TEST_CLASSES + "/parser/medium.properties");
        TokenStream ts = new TokenStream((Reader)fr);
        List tokenList = ts.tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(Token.TokenType.KEY, "K0"));
        witness.add(new Token(Token.TokenType.SEPARATOR, "="));
        witness.add(new Token(Token.TokenType.VALUE, "V0 "));
        witness.add(Token.TRAILING_BACKSLASH);
        witness.add(Token.EOL);
        witness.add(new Token(Token.TokenType.VALUE, "X"));
        witness.add(Token.EOL);
        witness.add(Token.EOL);
        witness.add(new Token(Token.TokenType.KEY, "K1"));
        witness.add(new Token(Token.TokenType.SEPARATOR, "="));
        witness.add(new Token(Token.TokenType.VALUE, "V1"));
        witness.add(Token.EOL);
        Assert.assertEquals(witness, (Object)tokenList);
    }

    @Test
    public void characters() throws FileNotFoundException {
        FileReader fr = new FileReader(CAL10NTestConstants.TEST_CLASSES + "/parser/characters.properties");
        TokenStream ts = new TokenStream((Reader)fr);
        List tokenList = ts.tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(Token.TokenType.KEY, "K0"));
        witness.add(new Token(Token.TokenType.SEPARATOR, "="));
        witness.add(new Token(Token.TokenType.VALUE, "a\nb"));
        witness.add(Token.EOL);
        witness.add(new Token(Token.TokenType.KEY, "K1"));
        witness.add(new Token(Token.TokenType.SEPARATOR, "="));
        witness.add(new Token(Token.TokenType.VALUE, "a\u2297b\nc"));
        witness.add(Token.EOL);
        Assert.assertEquals(witness, (Object)tokenList);
    }

    @Test
    public void resourceBundleWithSpecialCharacters() {
        ResourceBundle rb = ResourceBundle.getBundle("parser/characters");
        Assert.assertEquals((Object)"a\nb", (Object)rb.getObject("K0"));
        Assert.assertEquals((Object)"a\u2297b\nc", (Object)rb.getObject("K1"));
    }
}

