/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.sample.Colors;
import ch.qos.cal10n.util.AnnotationExtractorViaEnumClass;
import ch.qos.cal10n.util.CAL10NBundleFinderByClassloader;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.junit.Assert;
import org.junit.Test;

public class CAL10NResourceBundleFinderTest {
    ResourceBundle rb;
    String encoding;
    AnnotationExtractorViaEnumClass annotationExtractor = new AnnotationExtractorViaEnumClass(Colors.class);
    CAL10NBundleFinderByClassloader cal10NBundleFinderByClassloader = new CAL10NBundleFinderByClassloader(this.getClass().getClassLoader());

    @Test
    public void smoke() throws IOException {
        this.encoding = this.annotationExtractor.extractCharset(Locale.FRENCH);
        this.rb = this.cal10NBundleFinderByClassloader.getBundle("colors", Locale.FRENCH, this.encoding);
        Assert.assertEquals((Object)"les roses sont rouges", (Object)this.rb.getString("RED"));
    }

    @Test
    public void withCountry() throws IOException {
        this.encoding = this.annotationExtractor.extractCharset(Locale.FRENCH);
        this.rb = this.cal10NBundleFinderByClassloader.getBundle("colors", Locale.FRENCH, this.encoding);
        Assert.assertEquals((Object)"les roses sont rouges", (Object)this.rb.getString("RED"));
        this.rb = this.cal10NBundleFinderByClassloader.getBundle("colors", Locale.FRANCE, this.encoding);
        Assert.assertEquals((Object)"les roses sont rouges, et alors?", (Object)this.rb.getString("RED"));
    }

    @Test
    public void inDirectory() throws IOException {
        this.encoding = this.annotationExtractor.extractCharset(Locale.ENGLISH);
        this.rb = this.cal10NBundleFinderByClassloader.getBundle("foobar/sample", Locale.ENGLISH, this.encoding);
        Assert.assertEquals((Object)"A is the first letter of the alphabet", (Object)this.rb.getString("A"));
        this.rb = this.cal10NBundleFinderByClassloader.getBundle("foobar.sample", Locale.ENGLISH, this.encoding);
        Assert.assertEquals((Object)"A is the first letter of the alphabet", (Object)this.rb.getString("A"));
    }
}

