/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier;

import ch.qos.cal10n.sample.Colors;
import ch.qos.cal10n.sample.Countries;
import ch.qos.cal10n.sample.Minimal;
import ch.qos.cal10n.verifier.Cal10nError;
import ch.qos.cal10n.verifier.MessageKeyVerifier;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class MessageKeyVerifierTest {
    @Test
    public void smoke() {
        MessageKeyVerifier miv = new MessageKeyVerifier(Colors.class);
        List errorList = miv.verify(Locale.UK);
        Assert.assertEquals((long)0L, (long)errorList.size());
    }

    @Test
    public void withErrors_UK() {
        MessageKeyVerifier miv = new MessageKeyVerifier(Countries.class);
        List errorList = miv.verify(Locale.UK);
        Assert.assertEquals((long)2L, (long)errorList.size());
        Assert.assertEquals((Object)"CH", (Object)((Cal10nError)errorList.get(0)).getKey());
        Assert.assertEquals((Object)"BR", (Object)((Cal10nError)errorList.get(1)).getKey());
    }

    @Test
    public void withErrors_FR() {
        MessageKeyVerifier miv = new MessageKeyVerifier(Countries.class);
        List errorList = miv.verify(Locale.FRANCE);
        Assert.assertEquals((long)3L, (long)errorList.size());
        Assert.assertEquals((Object)"CH", (Object)((Cal10nError)errorList.get(0)).getKey());
        Assert.assertEquals((Object)"CN", (Object)((Cal10nError)errorList.get(1)).getKey());
        Assert.assertEquals((Object)"BR", (Object)((Cal10nError)errorList.get(2)).getKey());
    }

    @Test
    public void all() {
        MessageKeyVerifier mcv = new MessageKeyVerifier(Minimal.class);
        try {
            mcv.verifyAllLocales();
            Assert.fail((String)"an emum without LocaleData cannot be verifiied in one step");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

