/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.Cal10nTestConstants;
import ch.qos.cal10n.util.Parser;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    Map<String, String> map = new HashMap<String, String>();
    Map<String, String> witness = new HashMap<String, String>();

    @Test
    public void smoke() throws IOException {
        FileReader fr = new FileReader(Cal10nTestConstants.TEST_CLASSES + "/parser/smoke.properties");
        Parser parser = new Parser((Reader)fr, this.map);
        parser.parseAndPopulate();
        this.witness.put("K0", "V0");
        this.witness.put("K1", "V1");
        Assert.assertEquals(this.witness, this.map);
    }

    @Test
    public void medium() throws IOException {
        FileReader fr = new FileReader(Cal10nTestConstants.TEST_CLASSES + "/parser/medium.properties");
        Parser parser = new Parser((Reader)fr, this.map);
        parser.parseAndPopulate();
        this.witness.put("K0", "V0 X");
        this.witness.put("K1", "V1");
        Assert.assertEquals(this.witness, this.map);
    }

    @Test
    public void full() throws IOException {
        FileReader fr = new FileReader(Cal10nTestConstants.TEST_CLASSES + "/parser/full.properties");
        Parser parser = new Parser((Reader)fr, this.map);
        parser.parseAndPopulate();
        this.witness.put("K0", "V0 X");
        this.witness.put("K1", "V1");
        this.witness.put("K2", "V2 l1l2  l3");
        this.witness.put("K3", "V3 \t a");
        Assert.assertEquals(this.witness, this.map);
    }
}

