/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.Cal10nTestConstants;
import ch.qos.cal10n.util.Parser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ResourceBundleEncodingTest {
    Map<String, String> map = new HashMap<String, String>();
    Map<String, String> witness = new HashMap<String, String>();

    @Test
    public void greek_ISO8859_7() throws IOException {
        FileInputStream fis = new FileInputStream(Cal10nTestConstants.TEST_CLASSES + "/encodingsISO8859/a_el_GR.properties");
        InputStreamReader reader = new InputStreamReader((InputStream)fis, "ISO8859_7");
        Parser parser = new Parser((Reader)reader, this.map);
        parser.parseAndPopulate();
        String alpha = "\u03b1";
        this.witness.put("A", alpha);
        Assert.assertEquals(this.witness, this.map);
    }

    @Test
    public void turkishISO8859_3() throws IOException {
        FileInputStream fis = new FileInputStream(Cal10nTestConstants.TEST_CLASSES + "/encodingsISO8859/a_tr_TR.properties");
        InputStreamReader reader = new InputStreamReader((InputStream)fis, "ISO8859_3");
        Parser parser = new Parser((Reader)reader, this.map);
        parser.parseAndPopulate();
        char sCedilla = '\u015f';
        char iDotless = '\u0131';
        String witnessValue = "n" + iDotless + sCedilla + "an";
        this.witness.put("A", witnessValue);
        Assert.assertEquals(this.witness, this.map);
    }

    @Test
    public void greek_UTF8() throws IOException {
        FileInputStream fis = new FileInputStream(Cal10nTestConstants.TEST_CLASSES + "/encodingsUTF8/a_el_GR.properties");
        InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF8");
        Parser parser = new Parser((Reader)reader, this.map);
        parser.parseAndPopulate();
        String alpha = "\u03b1";
        this.witness.put("A", alpha);
        Assert.assertEquals(this.witness, this.map);
    }

    @Test
    public void turkishUTF8() throws IOException {
        FileInputStream fis = new FileInputStream(Cal10nTestConstants.TEST_CLASSES + "/encodingsUTF8/a_tr_TR.properties");
        InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF8");
        Parser parser = new Parser((Reader)reader, this.map);
        parser.parseAndPopulate();
        char sCedilla = '\u015f';
        char iDotless = '\u0131';
        String witnessValue = "n" + iDotless + sCedilla + "an";
        this.witness.put("A", witnessValue);
        Assert.assertEquals(this.witness, this.map);
    }
}

