/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.util.LexicalUtil;
import org.junit.Assert;
import org.junit.Test;

public class LexicalUtilTest {
    void verify(String in, String expected) {
        StringBuilder inBuf = new StringBuilder(in);
        StringBuilder outBuf = LexicalUtil.convertSpecialCharacters((StringBuilder)inBuf);
        Assert.assertEquals((Object)expected, (Object)outBuf.toString());
    }

    @Test
    public void identity() {
        this.verify("abc", "abc");
    }

    @Test
    public void empty() {
        this.verify("", "");
    }

    @Test
    public void withLF() {
        this.verify("a\\nbc", "a\nbc");
    }

    @Test
    public void withMultipleLF() {
        this.verify("a\\nb\\rc", "a\nb\rc");
        this.verify("a\\nb\\r", "a\nb\r");
        this.verify("\\nb\\r", "\nb\r");
    }

    @Test
    public void withUnicode() {
        this.verify("a\\u00FCbc", "a\u00fcbc");
        this.verify("a\\u00fcbc", "a\u00fcbc");
        this.verify("a\\u2297bc", "a\u2297bc");
        this.verify("a\\u2169bc", "a\u2169bc");
        this.verify("\\u2169", "\u2169");
        this.verify("a\\u2169", "a\u2169");
    }
}

