/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n;

import ch.qos.cal10n.MessageConveyor;
import ch.qos.cal10n.MessageConveyorException;
import ch.qos.cal10n.MessageParameterObj;
import ch.qos.cal10n.sample.Colors;
import ch.qos.cal10n.sample.Host;
import ch.qos.cal10n.sample.Labels;
import ch.qos.cal10n.sample.Minimal;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class MessageConveyorTest {
    @Test
    public void smoke_EN() {
        MessageConveyor rbbmc = new MessageConveyor(Locale.UK);
        String val = rbbmc.getMessage((Enum)Colors.BLUE, new Object[0]);
        Assert.assertEquals((Object)"violets are blue", (Object)val);
        val = rbbmc.getMessage((Enum)Colors.GREEN, new Object[]{"apples"});
        Assert.assertEquals((Object)"apples are green", (Object)val);
    }

    @Test
    public void nestedEnum_EN() {
        MessageConveyor rbbmc = new MessageConveyor(Locale.UK);
        String val = rbbmc.getMessage((Enum)Colors.RED, new Object[0]);
        Assert.assertEquals((Object)"roses are red", (Object)val);
        val = rbbmc.getMessage((Enum)Host.OtherColors.RED, new Object[0]);
        Assert.assertEquals((Object)"roses are red", (Object)val);
        val = rbbmc.getMessage((Enum)Host.OtherColors.BLUE, new Object[0]);
        Assert.assertEquals((Object)"violets are blue", (Object)val);
    }

    @Test
    public void smoke_FR() {
        MessageConveyor rbbmc = new MessageConveyor(Locale.FRANCE);
        String val = rbbmc.getMessage((Enum)Colors.BLUE, new Object[0]);
        Assert.assertEquals((Object)"les violettes sont bleues", (Object)val);
        val = rbbmc.getMessage((Enum)Colors.GREEN, new Object[]{"pommes"});
        Assert.assertEquals((Object)"les pommes sont verts", (Object)val);
    }

    @Test
    public void mpo() {
        MessageConveyor rbbmc = new MessageConveyor(Locale.UK);
        MessageParameterObj mpo = new MessageParameterObj((Enum)Colors.BLUE, new Object[0]);
        String val = rbbmc.getMessage(mpo);
        Assert.assertEquals((Object)"violets are blue", (Object)val);
        mpo = new MessageParameterObj((Enum)Colors.GREEN, new Object[]{"apples"});
        val = rbbmc.getMessage(mpo);
        Assert.assertEquals((Object)"apples are green", (Object)val);
    }

    @Test
    public void failedRBLookup() {
        MessageConveyor mc = new MessageConveyor(Locale.CHINA);
        try {
            mc.getMessage((Enum)Colors.BLUE, new Object[0]);
            Assert.fail((String)"missing exception");
        }
        catch (MessageConveyorException e) {
            Assert.assertEquals((Object)"Failed to locate resource bundle [colors] for locale [zh_CN] for enum type [ch.qos.cal10n.sample.Colors]", (Object)e.getMessage());
        }
    }

    @Test
    public void minimal() {
        MessageConveyor mc = new MessageConveyor(Locale.ENGLISH);
        Assert.assertEquals((Object)"A", (Object)mc.getMessage((Enum)Minimal.A, new Object[0]));
    }

    @Test
    public void specialCharacters() {
        MessageConveyor mc = new MessageConveyor(Locale.ENGLISH);
        Assert.assertEquals((Object)"A label \n with linefeed and unicode", (Object)mc.getMessage((Enum)Labels.L0, new Object[0]));
        Assert.assertEquals((Object)"Another \nlabel", (Object)mc.getMessage((Enum)Labels.L1, new Object[0]));
    }
}

