/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.util.CAL10NPropertyResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.ResourceBundle;

public class PropertyResourceBundleFinder {
    public static ResourceBundle getBundle(ClassLoader classLoader, String baseName, Locale locale) {
        baseName = baseName.replace('.', '/');
        String languageAndCountryCandidate = PropertyResourceBundleFinder.computeLanguageAndCountryCandidate(baseName, locale);
        String languageOnlyCandidate = PropertyResourceBundleFinder.computeLanguageOnlyCandidate(baseName, locale);
        CAL10NPropertyResourceBundle cprbLanguageOnly = PropertyResourceBundleFinder.makePropertyResourceBundle(classLoader, languageOnlyCandidate);
        CAL10NPropertyResourceBundle cprbLanguageAndCountry = null;
        if (languageAndCountryCandidate != null) {
            cprbLanguageAndCountry = PropertyResourceBundleFinder.makePropertyResourceBundle(classLoader, languageAndCountryCandidate);
        }
        if (cprbLanguageAndCountry != null) {
            cprbLanguageAndCountry.setParent(cprbLanguageOnly);
            return cprbLanguageAndCountry;
        }
        return cprbLanguageOnly;
    }

    private static CAL10NPropertyResourceBundle makePropertyResourceBundle(ClassLoader classLoader, String resourceCandiate) {
        CAL10NPropertyResourceBundle prb = null;
        URL url = classLoader.getResource(resourceCandiate);
        if (url != null) {
            try {
                InputStream in = PropertyResourceBundleFinder.openConnectionForUrl(url);
                prb = new CAL10NPropertyResourceBundle(in);
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return prb;
    }

    private static String computeLanguageAndCountryCandidate(String baseName, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (country != null && country.length() > 0) {
            return baseName + "_" + language + "_" + country + ".properties";
        }
        return null;
    }

    private static String computeLanguageOnlyCandidate(String baseName, Locale locale) {
        String language = locale.getLanguage();
        return baseName + "_" + language + ".properties";
    }

    private static InputStream openConnectionForUrl(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDefaultUseCaches(false);
        InputStream in = urlConnection.getInputStream();
        return in;
    }
}

