/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageParameterObj;
import ch.qos.cal10n.util.AnnotationExtractor;
import ch.qos.cal10n.util.PropertyResourceBundleFinder;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageConveyor
implements IMessageConveyor {
    Locale locale;

    public MessageConveyor(Locale locale) {
        this.locale = locale;
    }

    @Override
    public <E extends Enum<?>> String getMessage(E key, Object ... args) {
        String keyAsStr = key.toString();
        String baseName = AnnotationExtractor.getBaseName(key.getDeclaringClass());
        if (baseName == null) {
            throw new IllegalArgumentException("Missing @BaseName annotation in enum type [" + key.getClass().getName() + "]. See also " + "http://cal10n.qos.ch/codes.html#missingBaseNameAnnotation");
        }
        ResourceBundle rb = PropertyResourceBundleFinder.getBundle(this.getClass().getClassLoader(), baseName, this.locale);
        String value = rb.getString(keyAsStr);
        if (value == null) {
            return "No key found for " + keyAsStr;
        }
        if (args == null || args.length == 0) {
            return value;
        }
        return MessageFormat.format(value, args);
    }

    @Override
    public String getMessage(MessageParameterObj mpo) {
        if (mpo == null) {
            throw new IllegalArgumentException("MessageParameterObj argumument cannot be null");
        }
        return this.getMessage(mpo.getKey(), mpo.getArgs());
    }
}

