/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.impl.MetaDataBuilder;
import java.util.ArrayList;
import java.util.List;
import javaslang.collection.Array;
import javaslang.collection.Map;
import javaslang.collection.Set;
import javaslang.collection.Stream;

public final class CategoryColumn
implements Column<ColumnIds.CategoryColumnId> {
    private final ColumnIds.CategoryColumnId id;
    private final Array<String> categories;
    private final Array<Integer> categoryIndexPerRowIndex;
    private final Map<String, String> metaData;

    private CategoryColumn(ColumnIds.CategoryColumnId id, Array<String> categories, Array<Integer> categoryIndexPerRowIndex, Map<String, String> metaData) {
        this.id = id;
        this.categories = categories;
        this.categoryIndexPerRowIndex = categoryIndexPerRowIndex;
        this.metaData = metaData;
    }

    public static CategoryColumn of(ColumnIds.CategoryColumnId id, String value) {
        return CategoryColumn.builder(id).add(value).build();
    }

    public static CategoryColumn ofAll(ColumnIds.CategoryColumnId id, String ... values) {
        return CategoryColumn.builder(id).addAll(values).build();
    }

    public static CategoryColumn ofAll(ColumnIds.CategoryColumnId id, Iterable<String> values) {
        return CategoryColumn.builder(id).addAll(values).build();
    }

    public static Builder builder(ColumnIds.CategoryColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.CategoryColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.categoryIndexPerRowIndex.length();
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public String getValueAt(int rowIndex) {
        return (String)this.categories.get(((Integer)this.categoryIndexPerRowIndex.get(rowIndex)).intValue());
    }

    public Set<String> getCategories() {
        return this.categories.toSet();
    }

    public Stream<String> valueStream() {
        return Stream.range((int)0, (int)this.getRowCount()).map(this::getValueAt);
    }

    public static final class Builder
    implements Column.Builder<String, CategoryColumn> {
        private final ColumnIds.CategoryColumnId id;
        private final List<String> categories;
        private final List<Integer> categoryIndexPerRowIndex;
        private final MetaDataBuilder metaDataBuilder;

        private Builder(ColumnIds.CategoryColumnId id) {
            this.id = id;
            this.categories = new ArrayList<String>();
            this.categoryIndexPerRowIndex = new ArrayList<Integer>();
            this.metaDataBuilder = new MetaDataBuilder();
        }

        public Builder add(String value) {
            int categoryIndex = this.categories.indexOf(value);
            if (categoryIndex < 0) {
                this.categories.add(value);
                categoryIndex = this.categories.size() - 1;
            }
            this.categoryIndexPerRowIndex.add(categoryIndex);
            return this;
        }

        public Builder addAll(String ... values) {
            return this.addAll((Iterable<String>)Stream.of((Object[])values));
        }

        public Builder addAll(Iterable<String> values) {
            return (Builder)Stream.ofAll(values).foldLeft((Object)this, Builder::add);
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.putMetaData(key, value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAllMetaData(metaData);
            return this;
        }

        @Override
        public CategoryColumn build() {
            return new CategoryColumn(this.id, Array.ofAll(this.categories), Array.ofAll(this.categoryIndexPerRowIndex), (Map)this.metaDataBuilder.build());
        }
    }
}

