/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.AbstractColumn;
import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.impl.MetaDataBuilder;
import java.util.ArrayList;
import java.util.List;
import javaslang.collection.Array;
import javaslang.collection.Map;
import javaslang.collection.Stream;

public final class StringColumn
extends AbstractColumn<String, ColumnIds.StringColumnId> {
    private StringColumn(ColumnIds.StringColumnId id, Array<String> values, Map<String, String> metaData) {
        super(id, values, metaData);
    }

    public static StringColumn of(ColumnIds.StringColumnId id, String value) {
        return StringColumn.builder(id).add(value).build();
    }

    public static StringColumn ofAll(ColumnIds.StringColumnId id, String ... values) {
        return StringColumn.builder(id).addAll(values).build();
    }

    public static StringColumn ofAll(ColumnIds.StringColumnId id, Iterable<String> values) {
        return StringColumn.builder(id).addAll(values).build();
    }

    public static Builder builder(ColumnIds.StringColumnId id) {
        return new Builder(id);
    }

    public static final class Builder
    implements Column.Builder<String, StringColumn> {
        private final ColumnIds.StringColumnId id;
        private final List<String> values;
        private final MetaDataBuilder metaDataBuilder;

        private Builder(ColumnIds.StringColumnId id) {
            this.id = id;
            this.values = new ArrayList<String>();
            this.metaDataBuilder = new MetaDataBuilder();
        }

        public Builder add(String value) {
            this.values.add(value);
            return this;
        }

        public Builder addAll(String ... values) {
            return this.addAll((Iterable<String>)Stream.of((Object[])values));
        }

        public Builder addAll(Iterable<String> values) {
            this.values.addAll(Stream.ofAll(values).toJavaList());
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.putMetaData(key, value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAllMetaData(metaData);
            return this;
        }

        @Override
        public StringColumn build() {
            return new StringColumn(this.id, Array.ofAll(this.values), (Map)this.metaDataBuilder.build());
        }
    }
}

