/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.ColumnId;
import ch.netzwerg.paleo.ColumnType;

public interface ColumnIds {

    public static class GenericColumnId
    implements ColumnId {
        private final String name;
        private final ColumnType<?> type;

        public GenericColumnId(String name, ColumnType<?> type) {
            this.name = name;
            this.type = type;
        }

        public static GenericColumnId of(String name, ColumnType<?> type) {
            return new GenericColumnId(name, type);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ColumnType<?> getType() {
            return this.type;
        }
    }

    public static final class CategoryColumnId
    extends GenericColumnId {
        private CategoryColumnId(String name) {
            super(name, ColumnType.CATEGORY);
        }

        public static CategoryColumnId of(String name) {
            return new CategoryColumnId(name);
        }
    }

    public static final class TimestampColumnId
    extends GenericColumnId {
        private TimestampColumnId(String name) {
            super(name, ColumnType.TIMESTAMP);
        }

        public static TimestampColumnId of(String name) {
            return new TimestampColumnId(name);
        }
    }

    public static final class StringColumnId
    extends GenericColumnId {
        private StringColumnId(String name) {
            super(name, ColumnType.STRING);
        }

        public static StringColumnId of(String name) {
            return new StringColumnId(name);
        }
    }

    public static final class BooleanColumnId
    extends GenericColumnId {
        private BooleanColumnId(String name) {
            super(name, ColumnType.BOOLEAN);
        }

        public static BooleanColumnId of(String name) {
            return new BooleanColumnId(name);
        }
    }

    public static final class DoubleColumnId
    extends GenericColumnId {
        private DoubleColumnId(String name) {
            super(name, ColumnType.DOUBLE);
        }

        public static DoubleColumnId of(String name) {
            return new DoubleColumnId(name);
        }
    }

    public static final class IntColumnId
    extends GenericColumnId {
        private IntColumnId(String name) {
            super(name, ColumnType.INT);
        }

        public static IntColumnId of(String name) {
            return new IntColumnId(name);
        }
    }
}

