/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.BooleanColumn;
import ch.netzwerg.paleo.CategoryColumn;
import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnId;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.ColumnType;
import ch.netzwerg.paleo.DoubleColumn;
import ch.netzwerg.paleo.GenericColumn;
import ch.netzwerg.paleo.IntColumn;
import ch.netzwerg.paleo.StringColumn;
import ch.netzwerg.paleo.TimestampColumn;
import java.time.Instant;
import javaslang.collection.Array;
import javaslang.collection.IndexedSeq;
import javaslang.collection.Iterator;
import javaslang.collection.Set;

public final class DataFrame
implements Iterable<Column<?>> {
    private final Array<Column<?>> columns;
    private final int rowCount;

    private DataFrame(Array<Column<?>> columns) {
        this.columns = columns;
        this.rowCount = DataFrame.inferRowCount(columns);
    }

    private static int inferRowCount(IndexedSeq<Column<?>> columns) {
        if (columns.isEmpty()) {
            return 0;
        }
        Set rowCounts = columns.map(Column::getRowCount).distinct().toSet();
        if (rowCounts.length() > 1) {
            throw new IllegalArgumentException("Differing number of rows (i.e. column sizes)");
        }
        return (Integer)rowCounts.iterator().next();
    }

    public static DataFrame empty() {
        return new DataFrame(Array.empty());
    }

    public static DataFrame of(Column<?> column) {
        return DataFrame.ofAll(Array.of(column));
    }

    public static DataFrame ofAll(Column<?> ... columns) {
        return DataFrame.ofAll(Array.of((Object[])columns));
    }

    public static DataFrame ofAll(Iterable<Column<?>> columns) {
        return new DataFrame(Array.ofAll(columns));
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columns.length();
    }

    public IndexedSeq<ColumnId> getColumnIds() {
        return this.columns.map(Column::getId);
    }

    public IndexedSeq<Column<?>> getColumns() {
        return this.columns;
    }

    public IndexedSeq<String> getColumnNames() {
        return this.getColumnIds().map(ColumnId::getName);
    }

    public <C extends ColumnId> C getColumnId(int columnIndex, ColumnType<C> type) {
        Class<C> idType = type.getIdType();
        return (C)((ColumnId)idType.cast(((Column)this.columns.get(columnIndex)).getId()));
    }

    public IntColumn getColumn(ColumnIds.IntColumnId columnId) {
        return (IntColumn)this.getTypedColumn(columnId);
    }

    public DoubleColumn getColumn(ColumnIds.DoubleColumnId columnId) {
        return (DoubleColumn)this.getTypedColumn(columnId);
    }

    public BooleanColumn getColumn(ColumnIds.BooleanColumnId columnId) {
        return (BooleanColumn)this.getTypedColumn(columnId);
    }

    public StringColumn getColumn(ColumnIds.StringColumnId columnId) {
        return (StringColumn)this.getTypedColumn(columnId);
    }

    public TimestampColumn getColumn(ColumnIds.TimestampColumnId columnId) {
        return (TimestampColumn)this.getTypedColumn(columnId);
    }

    public CategoryColumn getColumn(ColumnIds.CategoryColumnId columnId) {
        return (CategoryColumn)this.getTypedColumn(columnId);
    }

    public <V, I extends ColumnIds.GenericColumnId> GenericColumn<V, I> getColumn(I columnId) {
        return (GenericColumn)this.getTypedColumn(columnId);
    }

    public Column<?> getColumn(ColumnId columnId) {
        return this.getTypedColumn(columnId);
    }

    public int getValueAt(int rowIndex, ColumnIds.IntColumnId columnId) {
        IntColumn column = (IntColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    public double getValueAt(int rowIndex, ColumnIds.DoubleColumnId columnId) {
        DoubleColumn column = (DoubleColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    public boolean getValueAt(int rowIndex, ColumnIds.BooleanColumnId columnId) {
        BooleanColumn column = (BooleanColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    public String getValueAt(int rowIndex, ColumnIds.StringColumnId columnId) {
        StringColumn column = (StringColumn)this.getTypedColumn(columnId);
        return (String)column.getValueAt(rowIndex);
    }

    public Instant getValueAt(int rowIndex, ColumnIds.TimestampColumnId columnId) {
        TimestampColumn column = (TimestampColumn)this.getTypedColumn(columnId);
        return (Instant)column.getValueAt(rowIndex);
    }

    public String getValueAt(int rowIndex, ColumnIds.CategoryColumnId columnId) {
        CategoryColumn column = (CategoryColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    public <V, I extends ColumnIds.GenericColumnId> V getValueAt(int rowIndex, I columnId) {
        GenericColumn column = (GenericColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    private <T extends Column<?>> T getTypedColumn(ColumnId columnId) {
        return (T)((Column)this.columns.find(c -> c.getId().equals(columnId)).getOption().getOrElseThrow(() -> {
            String msg = String.format("Unknown column id '%s'", columnId);
            throw new IllegalArgumentException(msg);
        }));
    }

    @Override
    public Iterator<Column<?>> iterator() {
        return this.columns.iterator();
    }
}

