/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GenericColumn<V, I extends ColumnIds.GenericColumnId>
implements Column<I> {
    private final I id;
    private final ImmutableList<V> values;
    private final ImmutableMap<String, String> metaData;

    protected GenericColumn(I id, List<V> values) {
        this(id, values, Collections.emptyMap());
    }

    protected GenericColumn(I id, List<V> values, Map<String, String> metaData) {
        this.id = id;
        this.values = ImmutableList.copyOf(values);
        this.metaData = ImmutableMap.copyOf(metaData);
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    public V getValueAt(int index) {
        return (V)this.values.get(index);
    }

    public List<V> getValues() {
        return this.values;
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public static abstract class Builder<V, I extends ColumnIds.GenericColumnId, C extends GenericColumn<V, I>>
    implements Column.Builder<C> {
        protected final I id;
        protected final ImmutableList.Builder<V> valueBuilder;
        protected final ImmutableMap.Builder<String, String> metaDataBuilder;

        public Builder(I id) {
            this.id = id;
            this.valueBuilder = ImmutableList.builder();
            this.metaDataBuilder = ImmutableMap.builder();
        }

        public final Builder<V, I, C> addAll(Iterable<V> values) {
            values.forEach(this::add);
            return this;
        }

        @SafeVarargs
        public final Builder<V, I, C> addAll(V ... values) {
            return this.addAll((Iterable<V>)Arrays.asList(values));
        }

        public final Builder<V, I, C> add(V value) {
            this.valueBuilder.add(value);
            return this;
        }

        public final Builder<V, I, C> putMetaData(String key, String value) {
            this.metaDataBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder<V, I, C> putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAll(metaData);
            return this;
        }
    }
}

