/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.DoubleStream;

public final class DoubleColumn
implements Column<ColumnIds.DoubleColumnId> {
    private final ColumnIds.DoubleColumnId id;
    private final double[] values;
    private final Map<String, String> metaData;

    public DoubleColumn(ColumnIds.DoubleColumnId id, DoubleStream values) {
        this(id, values, Collections.emptyMap());
    }

    public DoubleColumn(ColumnIds.DoubleColumnId id, DoubleStream values, Map<String, String> metaData) {
        this.id = id;
        this.values = values.toArray();
        this.metaData = ImmutableMap.copyOf(metaData);
    }

    public static Builder builder(ColumnIds.DoubleColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.DoubleColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    public double getValueAt(int index) {
        return this.values[index];
    }

    public DoubleStream getValues() {
        return Arrays.stream(this.values);
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public static final class Builder
    implements Column.Builder<DoubleColumn> {
        private final ColumnIds.DoubleColumnId id;
        private final DoubleStream.Builder valueBuilder;
        private final ImmutableMap.Builder<String, String> metaDataBuilder;

        public Builder(ColumnIds.DoubleColumnId id) {
            this.id = id;
            this.valueBuilder = DoubleStream.builder();
            this.metaDataBuilder = ImmutableMap.builder();
        }

        public Builder addAll(double ... values) {
            for (double value : values) {
                this.add(value);
            }
            return this;
        }

        public Builder add(double value) {
            this.valueBuilder.add(value);
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAll(metaData);
            return this;
        }

        @Override
        public DoubleColumn build() {
            return new DoubleColumn(this.id, this.valueBuilder.build(), (Map<String, String>)this.metaDataBuilder.build());
        }
    }
}

