/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class CategoryColumn
implements Column<ColumnIds.CategoryColumnId> {
    private final ColumnIds.CategoryColumnId id;
    private final int rowCount;
    private final List<String> categories;
    private final Lookup lookup;
    private final ImmutableMap<String, String> metaData;

    public CategoryColumn(ColumnIds.CategoryColumnId id, int rowCount, List<String> categories, Lookup lookup) {
        this(id, rowCount, categories, lookup, Collections.emptyMap());
    }

    public CategoryColumn(ColumnIds.CategoryColumnId id, int rowCount, List<String> categories, Lookup lookup, Map<String, String> metaData) {
        this.id = id;
        this.rowCount = rowCount;
        this.categories = ImmutableList.copyOf(categories);
        this.lookup = lookup;
        this.metaData = ImmutableMap.copyOf(metaData);
    }

    public static Builder builder(ColumnIds.CategoryColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.CategoryColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public String getValueAt(int rowIndex) {
        int categoryIndex = this.lookup.getCategoryIndex(rowIndex);
        return this.categories.get(categoryIndex);
    }

    public Set<String> getCategories() {
        return ImmutableSet.copyOf(this.categories);
    }

    public Stream<String> createValues() {
        return IntStream.range(0, this.rowCount).mapToObj(this::getValueAt);
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public static final class Builder
    implements Column.Builder<CategoryColumn> {
        private final ColumnIds.CategoryColumnId id;
        private final IntStream.Builder categoryIndexByRowIndexBuilder;
        private final List<String> categories;
        private final Map<String, Integer> categoryIndexByCategory;
        private final ImmutableMap.Builder<String, String> metaDataBuilder;

        private Builder(ColumnIds.CategoryColumnId id) {
            this.id = id;
            this.categoryIndexByRowIndexBuilder = IntStream.builder();
            this.categories = new ArrayList<String>();
            this.categoryIndexByCategory = new HashMap<String, Integer>();
            this.metaDataBuilder = ImmutableMap.builder();
        }

        public Builder addAll(Iterable<String> values) {
            values.forEach(this::add);
            return this;
        }

        public Builder addAll(String ... values) {
            return this.addAll(Arrays.asList(values));
        }

        public Builder add(String value) {
            Integer categoryIndex = this.categoryIndexByCategory.get(value);
            if (categoryIndex == null) {
                categoryIndex = this.categories.size();
                this.categoryIndexByCategory.put(value, categoryIndex);
                this.categories.add(value);
            }
            this.categoryIndexByRowIndexBuilder.add(categoryIndex);
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAll(metaData);
            return this;
        }

        @Override
        public CategoryColumn build() {
            int[] categoryIndexByRowIndex = this.categoryIndexByRowIndexBuilder.build().toArray();
            Lookup lookup = rowIndex -> categoryIndexByRowIndex[rowIndex];
            return new CategoryColumn(this.id, categoryIndexByRowIndex.length, this.categories, lookup, (Map<String, String>)this.metaDataBuilder.build());
        }
    }

    public static interface Lookup {
        public int getCategoryIndex(int var1);
    }
}

