/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.IntStream;

public final class IntColumn
implements Column<ColumnIds.IntColumnId> {
    private final ColumnIds.IntColumnId id;
    private final int[] values;
    private final Map<String, String> metaData;

    public IntColumn(ColumnIds.IntColumnId id, IntStream values) {
        this(id, values, Collections.emptyMap());
    }

    public IntColumn(ColumnIds.IntColumnId id, IntStream values, Map<String, String> metaData) {
        this.id = id;
        this.values = values.toArray();
        this.metaData = ImmutableMap.copyOf(metaData);
    }

    public static Builder builder(ColumnIds.IntColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.IntColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public int getValueAt(int index) {
        return this.values[index];
    }

    public IntStream getValues() {
        return Arrays.stream(this.values);
    }

    public static final class Builder
    implements Column.Builder<IntColumn> {
        private final ColumnIds.IntColumnId id;
        private final IntStream.Builder valueBuilder;
        private final ImmutableMap.Builder<String, String> metaDataBuilder;

        public Builder(ColumnIds.IntColumnId id) {
            this.id = id;
            this.valueBuilder = IntStream.builder();
            this.metaDataBuilder = ImmutableMap.builder();
        }

        public Builder addAll(int ... values) {
            for (int value : values) {
                this.add(value);
            }
            return this;
        }

        public Builder add(int value) {
            this.valueBuilder.add(value);
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAll(metaData);
            return this;
        }

        @Override
        public IntColumn build() {
            return new IntColumn(this.id, this.valueBuilder.build(), (Map<String, String>)this.metaDataBuilder.build());
        }
    }
}

