/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.BooleanColumn;
import ch.netzwerg.paleo.CategoryColumn;
import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnId;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.ColumnType;
import ch.netzwerg.paleo.DoubleColumn;
import ch.netzwerg.paleo.GenericColumn;
import ch.netzwerg.paleo.IntColumn;
import ch.netzwerg.paleo.StringColumn;
import ch.netzwerg.paleo.TimestampColumn;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class DataFrame {
    private final Map<ColumnId, Column<?>> columns;
    private final int rowCount;

    public DataFrame(Column<?> ... columns) {
        this(Arrays.asList(columns));
    }

    public DataFrame(List<Column<?>> columns) {
        this.rowCount = DataFrame.inferRowCount(columns);
        this.columns = DataFrame.createImmutableMap(columns);
    }

    private static int inferRowCount(List<Column<?>> columns) {
        if (columns.isEmpty()) {
            return 0;
        }
        Set rowCounts = columns.stream().map(Column::getRowCount).distinct().collect(Collectors.toSet());
        if (rowCounts.size() > 1) {
            throw new IllegalArgumentException("Differing number of rows (i.e. column sizes)");
        }
        return (Integer)rowCounts.iterator().next();
    }

    private static Map<ColumnId, Column<?>> createImmutableMap(List<Column<?>> columns) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        columns.forEach(c -> mapBuilder.put(c.getId(), c));
        return mapBuilder.build();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<ColumnId> getColumnIds() {
        return ImmutableList.copyOf(this.columns.keySet());
    }

    public List<Column<?>> getColumns() {
        return ImmutableList.copyOf(this.columns.values());
    }

    public List<String> getColumnNames() {
        return this.columns.keySet().stream().map(ColumnId::getName).collect(Collectors.toList());
    }

    public <C extends ColumnId> C getColumnId(int columnIndex, ColumnType<C> type) {
        Class<C> idType = type.getIdType();
        return (C)((ColumnId)idType.cast(ImmutableList.copyOf(this.columns.keySet()).get(columnIndex)));
    }

    public IntColumn getColumn(ColumnIds.IntColumnId columnId) {
        return (IntColumn)this.getTypedColumn(columnId);
    }

    public DoubleColumn getColumn(ColumnIds.DoubleColumnId columnId) {
        return (DoubleColumn)this.getTypedColumn(columnId);
    }

    public BooleanColumn getColumn(ColumnIds.BooleanColumnId columnId) {
        return (BooleanColumn)this.getTypedColumn(columnId);
    }

    public StringColumn getColumn(ColumnIds.StringColumnId columnId) {
        return (StringColumn)this.getTypedColumn(columnId);
    }

    public TimestampColumn getColumn(ColumnIds.TimestampColumnId columnId) {
        return (TimestampColumn)this.getTypedColumn(columnId);
    }

    public CategoryColumn getColumn(ColumnIds.CategoryColumnId columnId) {
        return (CategoryColumn)this.getTypedColumn(columnId);
    }

    public <V, I extends ColumnIds.GenericColumnId> GenericColumn<V, I> getColumn(I columnId) {
        return (GenericColumn)this.getTypedColumn(columnId);
    }

    public int getValueAt(int rowIndex, ColumnIds.IntColumnId columnId) {
        IntColumn column = (IntColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    public double getValueAt(int rowIndex, ColumnIds.DoubleColumnId columnId) {
        DoubleColumn column = (DoubleColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    public boolean getValueAt(int rowIndex, ColumnIds.BooleanColumnId columnId) {
        BooleanColumn column = (BooleanColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    public String getValueAt(int rowIndex, ColumnIds.StringColumnId columnId) {
        StringColumn column = (StringColumn)this.getTypedColumn(columnId);
        return (String)column.getValueAt(rowIndex);
    }

    public Instant getValueAt(int rowIndex, ColumnIds.TimestampColumnId columnId) {
        TimestampColumn column = (TimestampColumn)this.getTypedColumn(columnId);
        return (Instant)column.getValueAt(rowIndex);
    }

    public String getValueAt(int rowIndex, ColumnIds.CategoryColumnId columnId) {
        CategoryColumn column = (CategoryColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    public <V, I extends ColumnIds.GenericColumnId> V getValueAt(int rowIndex, I columnId) {
        GenericColumn column = (GenericColumn)this.getTypedColumn(columnId);
        return column.getValueAt(rowIndex);
    }

    private <T extends Column<?>> T getTypedColumn(ColumnId columnId) {
        return (T)this.columns.get(columnId);
    }
}

