/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.ColumnId;
import ch.netzwerg.paleo.ColumnIds;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class ColumnType<T extends ColumnId> {
    public static final ColumnType<ColumnIds.IntColumnId> INT = new ColumnType<ColumnIds.IntColumnId>("Int", ColumnIds.IntColumnId.class);
    public static final ColumnType<ColumnIds.DoubleColumnId> DOUBLE = new ColumnType<ColumnIds.DoubleColumnId>("Double", ColumnIds.DoubleColumnId.class);
    public static final ColumnType<ColumnIds.BooleanColumnId> BOOLEAN = new ColumnType<ColumnIds.BooleanColumnId>("Boolean", ColumnIds.BooleanColumnId.class);
    public static final ColumnType<ColumnIds.StringColumnId> STRING = new ColumnType<ColumnIds.StringColumnId>("String", ColumnIds.StringColumnId.class);
    public static final ColumnType<ColumnIds.TimestampColumnId> TIMESTAMP = new ColumnType<ColumnIds.TimestampColumnId>("Timestamp", ColumnIds.TimestampColumnId.class);
    public static final ColumnType<ColumnIds.CategoryColumnId> CATEGORY = new ColumnType<ColumnIds.CategoryColumnId>("Category", ColumnIds.CategoryColumnId.class);
    private static final Map<String, ColumnType<?>> TYPES_BY_DESCRIPTION = ImmutableMap.builder().put((Object)INT.getDescription(), INT).put((Object)DOUBLE.getDescription(), DOUBLE).put((Object)BOOLEAN.getDescription(), BOOLEAN).put((Object)STRING.getDescription(), STRING).put((Object)TIMESTAMP.getDescription(), TIMESTAMP).put((Object)CATEGORY.getDescription(), CATEGORY).build();
    private final String description;
    private final Class<T> idType;

    public ColumnType(String description, Class<T> idType) {
        this.description = description;
        this.idType = idType;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<T> getIdType() {
        return this.idType;
    }

    public static ColumnType<?> getByDescriptionOrDefault(String description, ColumnType<?> defaultType) {
        return TYPES_BY_DESCRIPTION.getOrDefault(description, defaultType);
    }

    public String toString() {
        return this.description;
    }
}

