/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import com.google.common.collect.ImmutableMap;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class BooleanColumn
implements Column<ColumnIds.BooleanColumnId> {
    private final ColumnIds.BooleanColumnId id;
    private final int rowCount;
    private final BitSet values;
    private final ImmutableMap<String, String> metaData;

    public BooleanColumn(ColumnIds.BooleanColumnId id, int rowCount, BitSet values) {
        this(id, rowCount, values, Collections.emptyMap());
    }

    public BooleanColumn(ColumnIds.BooleanColumnId id, int rowCount, BitSet values, Map<String, String> metaData) {
        this.id = id;
        this.rowCount = rowCount;
        this.values = (BitSet)values.clone();
        this.metaData = ImmutableMap.copyOf(metaData);
    }

    @Override
    public ColumnIds.BooleanColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public boolean getValueAt(int rowIndex) {
        return this.values.get(rowIndex);
    }

    public Stream<Boolean> getValues() {
        IntStream rowIndexStream = IntStream.range(0, this.rowCount);
        return rowIndexStream.mapToObj(this.values::get);
    }

    public ImmutableMap<String, String> getMetaData() {
        return this.metaData;
    }

    public static Builder builder(ColumnIds.BooleanColumnId id) {
        return new Builder(id);
    }

    public static final class Builder
    implements Column.Builder<BooleanColumn> {
        private final ColumnIds.BooleanColumnId id;
        private final AtomicInteger rowIndex;
        private final BitSet values;
        private final ImmutableMap.Builder<String, String> metaDataBuilder;

        public Builder(ColumnIds.BooleanColumnId id) {
            this.id = id;
            this.rowIndex = new AtomicInteger();
            this.values = new BitSet();
            this.metaDataBuilder = ImmutableMap.builder();
        }

        public Builder addAll(boolean ... values) {
            for (boolean value : values) {
                this.add(value);
            }
            return this;
        }

        public Builder add(boolean value) {
            this.values.set(this.rowIndex.getAndIncrement(), value);
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAll(metaData);
            return this;
        }

        @Override
        public BooleanColumn build() {
            return new BooleanColumn(this.id, this.rowIndex.get(), this.values, (Map<String, String>)this.metaDataBuilder.build());
        }
    }
}

