/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import java.util.Arrays;
import java.util.stream.IntStream;

public final class IntColumn
implements Column<ColumnIds.IntColumnId> {
    private final ColumnIds.IntColumnId id;
    private final int[] values;

    public IntColumn(ColumnIds.IntColumnId id, IntStream values) {
        this.id = id;
        this.values = values.toArray();
    }

    public static Builder builder(ColumnIds.IntColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.IntColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    public int getValueAt(int index) {
        return this.values[index];
    }

    public IntStream getValues() {
        return Arrays.stream(this.values);
    }

    public static final class Builder
    implements Column.Builder<IntColumn> {
        private final ColumnIds.IntColumnId id;
        private final IntStream.Builder valueBuilder;

        public Builder(ColumnIds.IntColumnId id) {
            this.id = id;
            this.valueBuilder = IntStream.builder();
        }

        public Builder addAll(int ... values) {
            for (int value : values) {
                this.add(value);
            }
            return this;
        }

        public Builder add(int value) {
            this.valueBuilder.add(value);
            return this;
        }

        @Override
        public IntColumn build() {
            return new IntColumn(this.id, this.valueBuilder.build());
        }
    }
}

