/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

public class GenericColumn<V, I extends ColumnIds.GenericColumnId>
implements Column<I> {
    private final I id;
    private final ImmutableList<V> values;

    protected GenericColumn(I id, List<V> values) {
        this.id = id;
        this.values = ImmutableList.copyOf(values);
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    public V getValueAt(int index) {
        return (V)this.values.get(index);
    }

    public List<V> getValues() {
        return this.values;
    }

    protected static abstract class Builder<V, I extends ColumnIds.GenericColumnId, C extends GenericColumn<V, I>>
    implements Column.Builder<C> {
        protected final I id;
        protected final ImmutableList.Builder<V> valueBuilder;

        public Builder(I id) {
            this.id = id;
            this.valueBuilder = ImmutableList.builder();
        }

        public final Builder<V, I, C> addAll(Iterable<V> values) {
            values.forEach(this::add);
            return this;
        }

        @SafeVarargs
        public final Builder<V, I, C> addAll(V ... values) {
            return this.addAll((Iterable<V>)Arrays.asList(values));
        }

        public final Builder<V, I, C> add(V value) {
            this.valueBuilder.add(value);
            return this;
        }
    }
}

