/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import java.util.Arrays;
import java.util.stream.DoubleStream;

public final class DoubleColumn
implements Column<ColumnIds.DoubleColumnId> {
    private final ColumnIds.DoubleColumnId id;
    private final double[] values;

    public DoubleColumn(ColumnIds.DoubleColumnId id, DoubleStream values) {
        this.id = id;
        this.values = values.toArray();
    }

    public static Builder builder(ColumnIds.DoubleColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.DoubleColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    public double getValueAt(int index) {
        return this.values[index];
    }

    public DoubleStream getValues() {
        return Arrays.stream(this.values);
    }

    public static final class Builder
    implements Column.Builder<DoubleColumn> {
        private final ColumnIds.DoubleColumnId id;
        private final DoubleStream.Builder valueBuilder;

        public Builder(ColumnIds.DoubleColumnId id) {
            this.id = id;
            this.valueBuilder = DoubleStream.builder();
        }

        public Builder addAll(double ... values) {
            for (double value : values) {
                this.add(value);
            }
            return this;
        }

        public Builder add(double value) {
            this.valueBuilder.add(value);
            return this;
        }

        @Override
        public DoubleColumn build() {
            return new DoubleColumn(this.id, this.valueBuilder.build());
        }
    }
}

