/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.impl.MetaDataBuilder;
import io.vavr.collection.Map;
import java.util.Arrays;
import java.util.stream.LongStream;

public class LongColumn
implements Column<ColumnIds.LongColumnId> {
    private final ColumnIds.LongColumnId id;
    private final long[] values;
    private final Map<String, String> metaData;

    private LongColumn(ColumnIds.LongColumnId id, LongStream values, Map<String, String> metaData) {
        this.id = id;
        this.values = values.toArray();
        this.metaData = metaData;
    }

    public static LongColumn of(ColumnIds.LongColumnId id, long value) {
        return LongColumn.builder(id).add(value).build();
    }

    public static LongColumn ofAll(ColumnIds.LongColumnId id, long ... values) {
        return LongColumn.builder(id).addAll(values).build();
    }

    public static LongColumn ofAll(ColumnIds.LongColumnId id, LongStream values) {
        return LongColumn.builder(id).addAll(values).build();
    }

    public static Builder builder(ColumnIds.LongColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.LongColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public long getValueAt(int index) {
        return this.values[index];
    }

    public LongStream valueStream() {
        return Arrays.stream(this.values);
    }

    public static final class Builder
    implements Column.Builder<Long, LongColumn> {
        private final ColumnIds.LongColumnId id;
        private final LongStream.Builder valueBuilder;
        private final MetaDataBuilder metaDataBuilder;

        private Builder(ColumnIds.LongColumnId id) {
            this.id = id;
            this.valueBuilder = LongStream.builder();
            this.metaDataBuilder = new MetaDataBuilder();
        }

        public Builder add(Long value) {
            this.valueBuilder.add(value);
            return this;
        }

        public Builder add(Integer value) {
            this.valueBuilder.add(value.intValue());
            return this;
        }

        public Builder addAll(long ... values) {
            return this.addAll(Arrays.stream(values));
        }

        public Builder addAll(Iterable<Long> values) {
            for (Long value : values) {
                this.valueBuilder.add(value);
            }
            return this;
        }

        public Builder addAll(LongStream values) {
            values.forEachOrdered(this::add);
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.putMetaData(key, value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAllMetaData(metaData);
            return this;
        }

        @Override
        public LongColumn build() {
            return new LongColumn(this.id, this.valueBuilder.build(), (Map)this.metaDataBuilder.build());
        }
    }
}

