/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.ColumnId;
import ch.netzwerg.paleo.ColumnIds;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;

public final class ColumnType<T extends ColumnId> {
    public static final ColumnType<ColumnIds.IntColumnId> INT = new ColumnType<ColumnIds.IntColumnId>("Int", ColumnIds.IntColumnId.class);
    public static final ColumnType<ColumnIds.LongColumnId> LONG = new ColumnType<ColumnIds.LongColumnId>("Long", ColumnIds.LongColumnId.class);
    public static final ColumnType<ColumnIds.DoubleColumnId> DOUBLE = new ColumnType<ColumnIds.DoubleColumnId>("Double", ColumnIds.DoubleColumnId.class);
    public static final ColumnType<ColumnIds.BooleanColumnId> BOOLEAN = new ColumnType<ColumnIds.BooleanColumnId>("Boolean", ColumnIds.BooleanColumnId.class);
    public static final ColumnType<ColumnIds.StringColumnId> STRING = new ColumnType<ColumnIds.StringColumnId>("String", ColumnIds.StringColumnId.class);
    public static final ColumnType<ColumnIds.TimestampColumnId> TIMESTAMP = new ColumnType<ColumnIds.TimestampColumnId>("Timestamp", ColumnIds.TimestampColumnId.class);
    public static final ColumnType<ColumnIds.CategoryColumnId> CATEGORY = new ColumnType<ColumnIds.CategoryColumnId>("Category", ColumnIds.CategoryColumnId.class);
    private static final Map<String, ColumnType<?>> TYPES_BY_DESCRIPTION = HashMap.ofEntries((Tuple2[])new Tuple2[]{Tuple.of((Object)INT.getDescription(), INT), Tuple.of((Object)LONG.getDescription(), LONG), Tuple.of((Object)DOUBLE.getDescription(), DOUBLE), Tuple.of((Object)BOOLEAN.getDescription(), BOOLEAN), Tuple.of((Object)STRING.getDescription(), STRING), Tuple.of((Object)TIMESTAMP.getDescription(), TIMESTAMP), Tuple.of((Object)CATEGORY.getDescription(), CATEGORY)});
    private final String description;
    private final Class<T> idType;

    public ColumnType(String description, Class<T> idType) {
        this.description = description;
        this.idType = idType;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<T> getIdType() {
        return this.idType;
    }

    public static ColumnType<?> getByDescriptionOrDefault(String description, ColumnType<?> defaultType) {
        return (ColumnType)TYPES_BY_DESCRIPTION.get((Object)description).getOrElse(defaultType);
    }

    public String toString() {
        return this.description;
    }
}

