/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.chabis;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class WordGenerator {
    public static final List<String> A_WORDS = ImmutableList.of((Object)"Aabee", (Object)"Aagoal", (Object)"Aah\u00e4ueli", (Object)"Aaleggi", (Object)"Abf\u00fc\u00e4r\u00e4", (Object)"Abgw\u00f6hnerli", (Object)"Abih\u00e4berli", (Object)"Absteller", (Object)"\u00c4ck\u00e4gstabi", (Object)"Aeg\u00e4scht\u00e4", (Object)"\u00c4gerscht", (Object)"Aiss\u00e4", (Object[])new String[]{"Al\u00e4b\u00f6ck", "Allmig", "Am\u00e4diisli", "Amp\u00e4s", "\u00c4nt\u00e4", "Ank\u00e4", "Arv\u00e4l\u00e4", "Ateigg\u00e4r", "\u00c4tti"});
    public static final List<String> B_WORDS = ImmutableList.of((Object)"Bab\u00e4", (Object)"Baabeli", (Object)"B\u00e4\u00e4bi", (Object)"B\u00e4\u00e4ggu", (Object)"B\u00e4\u00e4gu", (Object)"Baar\u00e4bli", (Object)"B\u00e4b\u00e4tsch", (Object)"B\u00e4dar\u00e4", (Object)"Baggu", (Object)"Balaari", (Object)"B\u00e4gu", (Object)"B\u00e4tti", (Object[])new String[]{"B\u00e4tziwasser", "Bal\u00e4", "Ballott\u00e4", "B\u00e4nggu", "B\u00e4nn\u00e4", "B\u00e4nz", "Bapf", "B\u00e4r\u00e4dr\u00e4ck", "B\u00e4ramsle", "Barisol", "Bau\u00e4l\u00e4", "Bau\u00e4l\u00e4dampf", "Beck\u00e4li", "Beirib\u00fc\u00fczel", "Beiz", "Beizer", "Bajaderli", "Bettm\u00fcmpfeli", "Bezgi", "Bhaltis", "Bhaupti", "Bi\u00e4li", "Bib\u00e4li", "Bicht", "Biib\u00e4li", "Biig", "Bileet", "Bimp\u00e4li", "Bin\u00e4tsch", "Binggis", "Bisnacht", "Bissa", "Blaascht", "Blaatere", "Bl\u00e4tz", "Bl\u00e4u\u00e4le", "Bliiberli", "Bliili", "Bloot\u00e4r\u00e4", "Bl\u00f6\u00f6terliwasser", "Blu\u00e4scht", "Blutzger", "Bobbi", "Bod\u00e4surri", "Bolg\u00e4", "Bog\u00e4hu\u00e4scht\u00e4", "B\u00f6l\u00e4", "B\u00f6l\u00e4d\u00fcnn\u00e4", "Bolagger", "Bollei", "Bongert", "B\u00f6\u00f6gg", "B\u00f6\u00f6limaa", "Bopp\u00e4", "Bow\u00e4\u00e4rli", "Bozu", "Brach\u00e4t", "Br\u00e4g\u00e4l", "Branberi", "Branschli", "Br\u00e4nt\u00e4", "Br\u00e4tschg\u00e4", "Br\u00e4usi", "Brigultini", "Brittli", "Broffl\u00e4", "Br\u00fc\u00e4ll\u00e4tsch", "Br\u00fcg\u00e4li", "Br\u00fcgel", "Br\u00fcgi", "Br\u00fc\u00fcsch\u00e4r\u00e4", "Br\u00fc\u00fctli", "Bschiss", "Bschlegi", "Bsch\u00fctti", "Bsetzi", "Bsetzistei", "B\u00fc\u00e4z", "B\u00fc\u00e4zer", "Buck", "Budig", "Bulg\u00e4", "Bump\u00e4r", "Bunt\u00e4n\u00f6\u00f6ri", "Bulscha", "Bummeli", "B\u00fcnzli", "B\u00fcppi", "Burdi", "B\u00fcrz\u00e4li", "B\u00fcrzi", "Buschi", "B\u00fcschl\u00e4", "B\u00fcsi", "Buttipfuschra", "Buttl\u00e4", "B\u00fctschgi", "B\u00fc\u00fcl\u00e4", "B\u00fc\u00fcrli", "Buzzimum\u00e4l", "Bygger"});
    public static final List<String> C_WORDS = ImmutableList.of((Object)"Chabis", (Object)"Chacheli", (Object)"Ch\u00e4d\u00e4r\u00e4t\u00e4", (Object)"Ch\u00e4ib", (Object)"Chapp\u00e4", (Object)"Charscht", (Object)"Ch\u00e4sn\u00e4pper", (Object)"Chatz\u00e4", (Object)"Chautsch", (Object)"Ch\u00e4utsch", (Object)"Cheeri", (Object)"Chef\u00e4", (Object[])new String[]{"Chefi", "Chegelisch\u00fceler", "Cheib", "Cheli", "Chemp", "Chescht\u00e4n\u00e4", "Chett\u00e4l\u00e4", "Chiib\u00e4tterli", "Chiibis", "Chil\u00e4l\u00f6chli", "Chilbi", "Chilt\u00e4r", "Chischt\u00e4", "Chislig", "Chittel", "Chlaau\u00e4", "Chlapf", "Chl\u00e4mmerli", "Chleck", "Chlef\u00e4l\u00e4", "Chl\u00f6\u00f6ni", "Chl\u00f6\u00f6p\u00e4", "Chl\u00f6pfer", "Chl\u00f6pfmoscht", "Chl\u00f6pfschiit", "Chl\u00f6\u00f6p\u00e4", "Chlotz", "Chl\u00fcbis", "Chluup\u00e4r\u00e4", "Chl\u00fcckerli", "Chlupf", "Chl\u00fctt\u00e4r", "Chluuf", "Chl\u00fc\u00fcr\u00e4", "Chnebel", "Chnel\u00e4", "Chnobli", "Chn\u00f6dli", "Chn\u00f6pfli", "Chn\u00f6rzli", "Chn\u00f6tsch", "Chn\u00fcppu", "Chnuschti", "Chn\u00fcttel", "Chnuup\u00e4saager", "Ch\u00f6derlig", "Ch\u00f6itsch", "Ch\u00f6l\u00e4", "Cholderi", "Ch\u00f6\u00f6tsch\u00e4li", "Chr\u00e4\u00e4z\u00e4", "Chr\u00e4bel", "Chr\u00e4bel", "Chrache", "Chr\u00e4l\u00e4li", "Chrampf", "Chratt\u00e4", "Chri\u00e4si", "Chreisp\u00e4l\u00e4", "Chriis", "Chritz", "Chr\u00f6mli", "Chromo", "Chr\u00f6pfli", "Chr\u00f6schp\u00e4li", "Chrosl\u00e4", "Chrott\u00e4p\u00f6sche", "Chr\u00f6tter", "Chrott", "Chr\u00fcckli", "Chrung\u00e4l\u00e4", "Chr\u00fcsch", "Chr\u00fcsim\u00fcsi", "Chrusli", "Chr\u00fc\u00fcsch", "Chruutsi\u00e4n\u00e4", "Chu\u00e4ch\u00e4tr\u00f6\u00f6li", "Chu\u00e4nagel", "Ch\u00fc\u00e4jer", "Ch\u00fcbelib\u00fc\u00fcrzel", "Chuchich\u00e4schtli", "Chuderluuri", "Ch\u00fcg\u00e4li", "Ch\u00fcmichn\u00fcpfer", "Ch\u00fcngel", "Chunscht", "Ch\u00fcrbis", "Chutt\u00e4", "Chutt\u00e4f\u00e4ck\u00e4", "Chuttl\u00e4", "Ch\u00fctten\u00e4", "Chutschi", "Chuttl\u00e4putz\u00e4t\u00e4", "Chuuschtof\u00e4", "Chuz\u00e4mischt"});
    public static final List<String> D_WORDS = ImmutableList.of((Object)"D\u00e4chlichapp\u00e4", (Object)"Dachch\u00e4nnel", (Object)"D\u00e4di", (Object)"Dampfi", (Object)"D\u00e4nk\u00e4li", (Object)"Dili", (Object)"Dol\u00e4", (Object)"D\u00f6ller", (Object)"Dooch\u00e4", (Object)"Dopleps", (Object)"Dotsch", (Object)"Dotteli", (Object[])new String[]{"Dr\u00e4m\u00e4l", "Dr\u00f6bsli", "Druck\u00e4t\u00e4", "D\u00fcndl\u00e4", "Durlips", "D\u00fcssu", "D\u00fctschi", "Dyrid\u00e4ri"});
    public static final List<String> E_WORDS = ImmutableList.of((Object)"Eign\u00e4", (Object)"Eier\u00f6hrli", (Object)"Eierschwamm", (Object)"Eiert\u00e4tsch", (Object)"Eschtrich", (Object)"Etro");
    public static final List<String> F_WORDS = ImmutableList.of((Object)"Fagetta", (Object)"Fagettazyt", (Object)"Fassduube", (Object)"Fasz\u00e4neetli", (Object)"Feischter", (Object)"Fek\u00e4r", (Object)"Feumer", (Object)"Feutsch\u00e4", (Object)"Fink\u00e4", (Object)"Fin\u00f6ggeli", (Object)"Fitz\u00e4", (Object)"Flad\u00e4", (Object[])new String[]{"Flaischch\u00e4\u00e4s", "Fluumer", "Fl\u00e4nderli", "Fl\u00e4r\u00e4", "Fl\u00e4tt\u00e4r\u00e4", "Forggl\u00e4", "Fritt\u00e4", "Fu\u00e4ss\u00e4t\u00e4", "F\u00e4chtli", "F\u00e4ck\u00e4", "F\u00e4gn\u00e4scht", "F\u00e4g\u00e4r", "F\u00e4rlisou", "F\u00e4tz\u00e4", "F\u00f6tz\u00e4l", "F\u00f6t\u00e4", "F\u00fcdli", "F\u00fcdlib\u00fcrger", "F\u00fc\u00fcrstei"});
    public static final List<String> G_WORDS = ImmutableList.of((Object)"Gacho", (Object)"Gad\u00e4", (Object)"Gaggalari", (Object)"Gal\u00f6\u00f6ri", (Object)"Gampiross", (Object)"Garacho", (Object)"Garett\u00e4", (Object)"Gebsi", (Object)"Geburi", (Object)"Gellerettli", (Object)"Gell\u00e4", (Object)"Gelt\u00e4", (Object[])new String[]{"Gertel", "Geufer", "Geuss", "Gfl\u00e4d\u00e4r", "Gfr\u00e4\u00e4sli", "Gfr\u00f6\u00f6rli", "Gh\u00fcderch\u00fcbel", "Gh\u00fcrsch", "Gib\u00e4", "Gigetschi", "Giggernillis", "Giireizi", "Giischter", "Giit", "Giizn\u00e4pper", "Gingg", "Ginnschett", "Gin\u00f6ffel", "Girgg\u00e4l", "Gischt\u00e4r", "Gizi", "Gi\u00e4l", "Gj\u00e4tt", "Glettiis\u00e4", "Gloschli", "Gluggsi", "Glugg\u00e4r\u00e4", "Glump", "Glungg\u00e4", "Gl\u00e4ck", "Gl\u00e4p\u00e4r\u00e4", "Gl\u00fcgg\u00e4r", "Gl\u00fcnggi", "Gl\u00fcscht\u00e4l\u00e4r", "Gnaad\u00e4h\u00fcchl\u00e4r", "Gnagi", "Gnuusch", "Gn\u00e4ggi", "Goggw\u00e4rgi", "Gonfi", "Goof", "Goof\u00e4", "Googg\u00e4li", "Gosch\u00e4", "Gotsch", "Gottfridschtutz", "Grandbere", "Griit\u00e4", "Grind", "Grittib\u00e4nz", "Grochsi", "Groggi", "Grungg\u00e4li", "Gruuperli", "Gr\u00e4tsch\u00e4", "Gr\u00e4ttimann", "Gr\u00e4ubschi", "Gr\u00f6bschi", "Gr\u00f6\u00f6ggu", "Gr\u00fcezini", "Gr\u00fc\u00fcs\u00e4l", "Gschiss", "Gschleik", "Gschl\u00fcder", "Gschmeus", "Gschn\u00e4pper", "Gschpill", "Gschpusi", "Gschp\u00e4\u00e4ndli", "Gschp\u00fcri", "Gschtr\u00fcpp", "Gschtungg", "Gscht\u00e4ltli", "Gscht\u00fcrm", "Gschwellti", "Gs\u00fcchti", "Guf\u00e4l\u00e4", "Guf\u00e4r\u00e4", "Gugelfu\u00e4r", "Gugerli", "Guggeer\u00e4", "Gugger", "Guggern\u00e4lli", "Guggumer\u00e4", "Gugg\u00e4musig", "Gugg\u00e4rscht\u00fctz", "Gugg\u00e4rziitli", "Gumel", "Gump", "Gumsl\u00e4", "Gunt\u00e4", "Gupf", "Guschteni", "Gusi", "Gutsch", "Gutschi", "Gutter\u00e4", "Gu\u00e4g\u00e4", "Gu\u00e4zli", "Gv\u00e4tterliz\u00fc\u00fcg", "Gwaggli", "Gwunder", "G\u00e4ldseck\u00e4l", "G\u00e4lleriebli", "G\u00e4nterli", "G\u00e4zzi", "G\u00f6ifer", "G\u00f6p\u00e4l", "G\u00f6rbsi", "G\u00fcggi", "G\u00fcli", "G\u00fcll\u00e4", "G\u00fcnsch\u00e4", "G\u00fcsel", "G\u00fcselch\u00fcb\u00e4l", "G\u00fcwett\u00e4", "G\u00fc\u00fcdelmentig", "G\u00fc\u00fcd\u00e4lm\u00e4ntig", "G\u00fc\u00fcgs", "G\u00fc\u00fcrbschi"});
    public static final List<String> H_WORDS = ImmutableList.of((Object)"Haag", (Object)"Haaghuuri", (Object)"Habasch", (Object)"Hab\u00e4", (Object)"Haf\u00e4\u00e4ch\u00e4\u00e4s", (Object)"Hampfl\u00e4", (Object)"Hamp\u00e4issi", (Object)"Hand\u00f6rg\u00e4li", (Object)"Hanf", (Object)"Harasse", (Object)"Hebi", (Object)"Heftli", (Object[])new String[]{"Hegel", "Heiti", "Helg\u00e4", "Hels\u00e4t\u00e4", "Hemmliglunggi", "Herg\u00f6ttli", "Heubeeri", "Heuel", "Heug\u00fcmper", "Heu\u00e4t", "Hezgi", "Hick", "Hiischi", "Hiiti", "Himm\u00e4lg\u00fc\u00fcg\u00e4li", "Hinderlig", "Hiub\u00e4", "Hizgi", "Hi\u00e4siger", "Hochwasser", "Hodu", "Hoger", "Holder", "Holler", "Holloderi", "Hopzger", "Horner", "Hosli", "Hos\u00e4lotteri", "Hotsch", "Hotschguf\u00e4", "Houdi", "Hudi", "Hudig\u00e4\u00e4gg\u00e4l\u00e4r", "Hudl\u00e4", "Hud\u00e4l", "Hud\u00e4r\u00e4", "Hundsverloch\u00e4t\u00e4", "Huppi", "Hurlibu\u00e4b", "Hurscht", "Huustag\u00e4", "H\u00e4lslig", "H\u00e4mli", "H\u00e4mpf\u00e4li", "H\u00e4p\u00e4r\u00e4pr\u00e4g\u00e4l", "H\u00e4p\u00f6ri", "H\u00e4rd\u00f6pfel", "H\u00e4tzle", "H\u00e4uchel", "H\u00e4uptli", "H\u00e4\u00e4bi", "H\u00e4\u00e4rd", "H\u00f6ck", "H\u00f6tsch", "H\u00f6umi", "H\u00f6\u00f6pt\u00e4t\u00e4", "H\u00f6\u00f6si", "H\u00fcberlig", "H\u00fcb\u00e4li", "H\u00fcenervogel", "H\u00fcltsch\u00e4", "H\u00fcltsch\u00e4gumm\u00e4l", "H\u00fcnti", "H\u00fcntschi", "H\u00fcrbi", "H\u00fcsli", "H\u00fctt\u00e4", "H\u00fc\u00e4nerhuut"});
    public static final List<String> I_WORDS = ImmutableList.of((Object)"Ilge", (Object)"Imbi");
    public static final List<String> J_WORDS = ImmutableList.of((Object)"Joggel", (Object)"Juuchzer", (Object)"J\u00e4nn\u00e4r", (Object)"J\u00f6ggelichaschte", (Object)"J\u00fcntli");
    public static final List<String> K_WORDS = ImmutableList.of((Object)"Kischt\u00e4r", (Object)"Komod\u00e4", (Object)"Krem\u00e4nzer", (Object)"Kroki", (Object)"Kummet", (Object)"Kundikt\u00f6r", (Object)"K\u00f6hl\u00e4", (Object)"K\u00f6si");
    public static final List<String> L_WORDS = ImmutableList.of((Object)"Laabata", (Object)"Laarv\u00e4", (Object)"Laf\u00e4ri", (Object)"Landj\u00e4ger", (Object)"Lappi", (Object)"Latschi", (Object)"Laueri", (Object)"Laui", (Object)"Lav\u00e4ri", (Object)"Legoor\u00e4", (Object)"Lilach\u00e4", (Object)"Lism\u00e4r", (Object[])new String[]{"Loob\u00e4", "Loosch\u00e4", "Lotteri", "Luftibus", "Lusch\u00e4", "Luuser", "Luuszapf\u00e4", "L\u00e4di", "L\u00e4mp\u00e4", "L\u00e4tsch", "L\u00e4ubi", "L\u00e4ufterli", "L\u00f6cherbecki", "L\u00f6ff\u00e4l", "L\u00f6li", "L\u00fc\u00fcrlibr\u00fce"});
    public static final List<String> M_WORDS = ImmutableList.of((Object)"Maad", (Object)"Maanu", (Object)"Magerlieni", (Object)"Magusil", (Object)"Maitli", (Object)"Malafiz", (Object)"Malun", (Object)"Manz\u00e4l\u00e4", (Object)"Man\u00f6ggel", (Object)"Masel", (Object)"Mektig", (Object)"Melchterli", (Object[])new String[]{"Mertel", "Miggl\u00e4", "Minggis", "Mischmasch", "Mischt", "Mitli", "Mock\u00e4", "Modi", "Moltagig", "Mont\u00e4r\u00e4", "Moor\u00e4", "Moscht", "Moswey", "Mos\u00e4", "Moudi", "Moutschi", "Muesueli", "Mugerli", "Mungg", "Muni", "Mutschli", "Mutz", "Mutz\u00e4", "Muuloorg\u00e4l\u00e4", "Mu\u00e4l\u00e4", "Mu\u00e4ma", "M\u00e4i\u00e4", "M\u00e4i\u00e4riisli", "M\u00e4udi", "M\u00f6d\u00e4li", "M\u00f6ff", "M\u00f6\u00f6d\u00e4li", "M\u00fcmpf\u00e4li", "M\u00fcntschi", "M\u00fcrgu", "M\u00fc\u00fcs"});
    public static final List<String> N_WORDS = ImmutableList.of((Object)"Nagwer", (Object)"Nani", (Object)"Nast\u00fcechli", (Object)"Nauggi", (Object)"Nauschl\u00e4", (Object)"Nedli", (Object)"Neni", (Object)"Nepot", (Object)"Nigg\u00e4l", (Object)"Niidl\u00e4", (Object)"Ni\u00e4nen\u00fc\u00fcteli", (Object)"Nobisser", (Object[])new String[]{"Nogg\u00e4", "Nopp\u00e4r\u00e4", "Nud\u00e4li", "Nuggi", "Nunni", "Nuusch\u00e4li", "N\u00e4ggel", "N\u00e4ll", "N\u00e4scht", "N\u00e4\u00e4dlig", "N\u00fcsch\u00e4l", "N\u00fc\u00fcteli"});
    public static final List<String> O_WORDS = ImmutableList.of((Object)"Obenigad\u00e4", (Object)"Oelstiirzli", (Object)"Ordin\u00e4ri");
    public static final List<String> P_WORDS = ImmutableList.of((Object)"Paggu", (Object)"Pajass", (Object)"Palka", (Object)"Palota", (Object)"Panasch", (Object)"Pandur", (Object)"Paring\u00e4l", (Object)"Perron", (Object)"Pfeuk", (Object)"Pfiffolt\u00e4r\u00e4", (Object)"Pfiff\u00e4bibi", (Object)"Pfifouter", (Object[])new String[]{"Pflotsch", "Pflut\u00e4r\u00e4", "Pfn\u00fcsel", "Pfn\u00fcs\u00e4l", "Pfupf", "Pfuschi", "Pfuus", "Pfyff\u00e4li", "Pf\u00e4tana", "Pf\u00fcderi", "Pf\u00fcnderli", "Pf\u00fc\u00fcsi", "Pf\u00fc\u00fcsli", "Piggee", "Pin\u00e4tsch", "Plaggeischt", "Plag\u00f6\u00f6ri", "Plaud\u00e4ri", "Plausch", "Pleg\u00e4r", "Plofi", "Plutzg\u00e4r", "Pl\u00e4sch\u00e4r", "Pl\u00e4ttli", "Pl\u00e4tz", "Pl\u00e4tzli", "Pl\u00fctschi", "Ponten\u00f6ri", "Poor", "Poppi", "Portmonee", "Poschettli", "Potschamb\u00e4r", "Pottasch\u00e4", "Prattig", "Preusivogel", "Pulsch\u00e4", "Pumper", "Pumpi", "P\u00f6schtler", "P\u00f6\u00f6t\u00e4t\u00e4rli", "P\u00fclferli", "P\u00fcnt"});
    public static final List<String> Q_WORDS = ImmutableList.of((Object)"Quaaki", (Object)"Quadradsploderi", (Object)"Quaksalber", (Object)"Qu\u00e4rtli");
    public static final List<String> R_WORDS = ImmutableList.of((Object)"Raf\u00e4", (Object)"Rampas", (Object)"Rand\u00e4", (Object)"Rank", (Object)"Ranz\u00e4", (Object)"Ranz\u00e4pfiife", (Object)"Rapp\u00e4schpalter", (Object)"Ratzmuus", (Object)"Rauft", (Object)"Reckholder", (Object)"Ribel", (Object)"Riibiis\u00e4", (Object[])new String[]{"Riitigampfi", "Riitiseili", "Riitschu\u00e4l", "Rossboll\u00e4", "Rosschopf", "Ruf\u00e4", "Rundum\u00e4li", "Rung", "Runggl\u00e4", "Rungguuserli", "Rupf", "Ru\u00e4ch", "R\u00e4mschala", "R\u00e4ppli", "R\u00e4tschb\u00e4si", "R\u00e4\u00e4b\u00e4", "R\u00e4\u00e4f", "R\u00e4\u00e4vel", "R\u00fcfi", "R\u00fcm\u00e4", "R\u00fc\u00e4bli"});
    public static final List<String> S_WORDS = ImmutableList.of((Object)"Salaath\u00e4uptli", (Object)"Samichlaus", (Object)"Schaal\u00e4", (Object)"Schabziger", (Object)"Schafsek\u00e4l", (Object)"Scharm\u00fctzel", (Object)"Schassee", (Object)"Schees\u00e4", (Object)"Schees\u00e4wag\u00e4", (Object)"Scheich\u00e4", (Object)"Schelf\u00e4r\u00e4", (Object)"Scheube", (Object[])new String[]{"Schiil\u00e4d\u00e4", "Schiin\u00e4r", "Schiit\u00e4rbiig", "Schiner", "Schisshas", "Schlarp\u00e4", "Schlawiner", "Schlegel", "Schlick", "Schloff", "Schlud\u00e4ri", "Schlufi", "Schlunggi", "Schlupf", "Schluurgg\u00e4", "Schl\u00e4mp\u00e4", "Schl\u00e4per\u00e4", "Schl\u00e4uf\u00e4li", "Schl\u00f6tterlig", "Schl\u00f6\u00f6f", "Schmalz", "Schmatz", "Schmichu", "Schmiis\u00e4", "Schmi\u00e4r", "Schmutz", "Schmutzli", "Schnaagg\u00e4", "Schnauz", "Schneeschn\u00fc\u00fctzi", "Schnoderbueb", "Schnorri", "Schnor\u00e4", "Schnuder", "Schnuderi", "Schnuderlump\u00e4", "Schnud\u00e4rgoof", "Schnurpfi", "Schnurr\u00e4giig\u00e4", "Schnur\u00e4giig\u00e4", "Schnuuf\u00e4r", "Schn\u00e4b\u00e4li", "Schn\u00e4derig\u00e4x", "Schn\u00e4gg", "Schn\u00e4pf", "Schn\u00e4pper", "Schn\u00fcg\u00e4l", "Schol\u00e4", "Schooss", "Schopf", "Schopp\u00e4", "Schorn\u00e4gg\u00e4li", "Schpaaz\u00e4", "Schpargim\u00e4nt\u00e4", "Schparz", "Schpatzig", "Schpeuz", "Schpiiggeli", "Schpiiss\u00e4", "Schpinnhup\u00e4l\u00e4", "Schpinoggel", "Schpri\u00e4nz\u00e4l", "Schprung", "Schprutz", "Schpunt\u00e4", "Schranz", "Schrass\u00e4b\u00fctschgi", "Schroot\u00e4r", "Schropp\u00e4", "Schtabell\u00e4", "Schtang\u00e4", "Schtick'l", "Schtierz", "Schtier\u00e4naug", "Schtift", "Schtiiz\u00e4", "Schti\u00e4ragrind", "Schtorz\u00e4", "Schtraggl\u00e4", "Schtriitzi", "Schtri\u00e4li", "Schtri\u00e4m\u00e4", "Schtropf", "Schtrubuus\u00e4t\u00e4", "Schtr\u00e4\u00e4l", "Schtr\u00e4\u00e4z\u00e4r", "Schtuch\u00e4", "Schtump\u00e4", "Schtunggis", "Schtuss", "Schtutz", "Scht\u00e4g\u00e4", "Scht\u00e4g\u00e4leen\u00e4", "Scht\u00e4rnlifad\u00e4", "Scht\u00f6ck", "Scht\u00f6ckli", "Scht\u00f6rg\u00e4li", "Scht\u00fctz", "Schudel", "Schuderh\u00e4u\u00e4l", "Schutzli", "Schwaab", "Schwafli", "Schwald\u00e4ri", "Schwetti", "Schwiinigg\u00e4l", "Schwiinigs", "Schwint\u00e4", "Schwir\u00e4", "Schwi\u00e4r\u00e4", "Schw\u00e4mm", "Sch\u00e4rm\u00e4", "Sch\u00f6cheli", "Sch\u00f6pfli", "Sch\u00fcchl\u00e4d\u00e4r", "Sch\u00fcrger", "Sch\u00fctti", "Sch\u00fc\u00fcb\u00e4", "Seechter", "Seich", "Seigl", "Seiliplampi", "Sekel", "Setzlig", "Sib\u00e4si\u00e4ch", "Sidian", "Sirach", "Si\u00e4ch", "Si\u00e4neli", "Soigoof", "Souer", "St\u00e4ndligurre", "Sudel", "Suff", "Suggi", "Summervogel", "Sunn\u00e4wirbl", "Supf", "Surrimurri", "Suurchabis", "Suurnippel", "S\u00e4g\u00e4ss\u00e4", "S\u00e4ubluem\u00e4", "S\u00e4uniggel", "S\u00f6iniggel", "S\u00fcff\u00e4l", "S\u00fcrmel", "S\u00fc\u00fcfferli", "S\u00fc\u00fcgw\u00e4sch", "S\u00fc\u00fcli"});
    public static final List<String> T_WORDS = ImmutableList.of((Object)"Tablar", (Object)"Taburettli", (Object)"Tampa", (Object)"Tauss\u00e4", (Object)"Teigaff", (Object)"Thek", (Object)"Titti", (Object)"Tocha", (Object)"Tolgg\u00e4", (Object)"Tol\u00e4", (Object)"Toor\u00e4bueb", (Object)"Totsch", (Object[])new String[]{"Totz", "Triichl\u00e4", "Tritt", "Trottwar", "Truck\u00e4", "Tr\u00e4mel", "Tr\u00e4\u00e4sch", "Tr\u00fcmpi", "Tschifer\u00e4", "Tschingg", "Tschook\u00e4", "Tschooli", "Tschoope", "Tschuderheuel", "Tschugger", "Tschumpel", "Tschump\u00e4li", "Tschutt", "Tsch\u00e4p\u00e4r", "Tsch\u00e4tt\u00e4r\u00e4", "Tsch\u00fc\u00fcpi", "Tubl", "Tulung", "Turpe", "Tutsch", "Tutsuit", "Tu\u00e4ch", "T\u00e4tsch", "T\u00e4tschburg\u00e4r", "T\u00e4tschi", "T\u00e4tschmeischter", "T\u00e4\u00e4feli", "T\u00f6ffli", "T\u00f6ggel", "T\u00f6rgg\u00e4", "T\u00f6z", "T\u00f6\u00f6pl\u00e4r", "T\u00f6\u00f6p\u00e4", "T\u00fcndl\u00e4", "T\u00fcnl\u00e4", "T\u00fcpfi", "T\u00fcpflischiisser", "T\u00fctschi", "T\u00fc\u00fcrfall\u00e4"});
    public static final List<String> U_WORDS = ImmutableList.of((Object)"Umbeisgi", (Object)"Unertiner", (Object)"Ungfell", (Object)"Untscha", (Object)"Uschtig", (Object)"Us\u00e4g\u00e4ld", (Object)"Us\u00e4schtuel\u00e4t\u00e4", (Object)"Uufsteller", (Object)"Uufw\u00e4schluder\u00e4");
    public static final List<String> V_WORDS = ImmutableList.of((Object)"Velo", (Object)"Versuecherli", (Object)"Vi\u00e4rlig", (Object)"V\u00f6rteli", (Object)"V\u00f6rtuech");
    public static final List<String> W_WORDS = ImmutableList.of((Object)"Waggis", (Object)"Waggu", (Object)"Wank", (Object)"Watsch\u00e4", (Object)"Webst\u00fcbler", (Object)"Weggli", (Object)"Wind\u00e4", (Object)"Wobi", (Object)"Wormassl\u00e4", (Object)"Wydlischryner", (Object)"W\u00e4d\u00e4l\u00e4", (Object)"W\u00e4j\u00e4", (Object[])new String[]{"W\u00e4lschland", "W\u00e4tterlain\u00e4", "W\u00f6sch", "W\u00fcmm\u00e4t"});
    public static final List<String> X_WORDS = ImmutableList.of((Object)"Xundheit");
    public static final List<String> Y_WORDS = ImmutableList.of((Object)"Ygrek");
    public static final List<String> Z_WORDS = ImmutableList.of((Object)"Zain\u00e4", (Object)"Zapf\u00e4", (Object)"Zappi", (Object)"Zaupf", (Object)"Zei\u00e4li", (Object)"Ziischtig", (Object)"Zil\u00e4t\u00e4", (Object)"Zimis", (Object)"Zingg\u00e4", (Object)"Zischgeli", (Object)"Zis\u00e4li", (Object)"Zi\u00e4meli", (Object[])new String[]{"Zmorg\u00e4", "Zn\u00fc\u00fcni", "Zoggl\u00e4", "Zolgg\u00e4", "Zoobig", "Zottl\u00e4", "Zougg\u00e4", "Zvieri", "Zwetschg\u00e4", "Zwi\u00e4ri", "Zw\u00e4nzgerst\u00fcckli", "Z\u00e4ltli", "Z\u00e4nnihaar", "Z\u00fcch\u00e4", "Z\u00fcckerli", "Z\u00fch\u00e4", "Z\u00fcpf\u00e4"});
    public static final List<String> ALL_WORDS = ImmutableList.builder().addAll(A_WORDS).addAll(B_WORDS).addAll(C_WORDS).addAll(D_WORDS).addAll(E_WORDS).addAll(F_WORDS).addAll(G_WORDS).addAll(H_WORDS).addAll(I_WORDS).addAll(J_WORDS).addAll(K_WORDS).addAll(L_WORDS).addAll(M_WORDS).addAll(N_WORDS).addAll(O_WORDS).addAll(P_WORDS).addAll(Q_WORDS).addAll(R_WORDS).addAll(S_WORDS).addAll(T_WORDS).addAll(U_WORDS).addAll(V_WORDS).addAll(W_WORDS).addAll(X_WORDS).addAll(Y_WORDS).addAll(Z_WORDS).build();
    private final Random random;

    public WordGenerator() {
        this(new Random());
    }

    public WordGenerator(Random random) {
        this.random = random;
    }

    public List<String> randomWords(int count) {
        return WordGenerator.randomWords(this.random, count);
    }

    public List<String> uniqueRandomWords(int count) {
        return WordGenerator.uniqueRandomWords(this.random, count);
    }

    public static List<String> randomWords(Random random, int count) {
        IntStream randomIndices = IntStream.generate(() -> random.nextInt(ALL_WORDS.size())).limit(count);
        return randomIndices.mapToObj(ALL_WORDS::get).collect(Collectors.toList());
    }

    public static List<String> uniqueRandomWords(Random random, int count) {
        if (count >= ALL_WORDS.size()) {
            throw new IllegalArgumentException("Can maximally return " + ALL_WORDS.size() + " unique words");
        }
        if (count <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> words = new ArrayList<String>(ALL_WORDS);
        Collections.shuffle(words, random);
        return words.subList(0, count);
    }
}

